/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core;

import java.io.IOException;
import java.io.OutputStream;

public class WrappedByteArrayOutputStream
extends OutputStream {
    private final int startingOffset;
    private byte[] buffer;
    private int offset;

    public WrappedByteArrayOutputStream(byte[] buffer, int bufferOffset) {
        this.buffer = buffer;
        this.offset = bufferOffset;
        this.startingOffset = bufferOffset;
    }

    public int getPosition() {
        return this.offset - this.startingOffset;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.offset == this.buffer.length) {
            throw new IOException("An incorrect number of bytes was read from the connection. The connection may have been closed.");
        }
        this.buffer[this.offset] = (byte)b;
        ++this.offset;
    }
}

