/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.RequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ServiceProperties;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ServicePropertiesHandler;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ServicePropertiesSerializer;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ServiceStats;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ServiceStatsHandler;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentials;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsAnonymous;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageUri;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.BaseRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.RequestLocationMode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.StorageRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.StreamMd5AndLength;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

public abstract class ServiceClient {
    private StorageUri storageUri;
    protected StorageCredentials credentials;
    private boolean usePathStyleUris;

    protected ServiceClient(StorageUri storageUri, StorageCredentials credentials) {
        Utility.assertNotNull("baseUri", storageUri);
        if (!storageUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", storageUri));
        }
        this.credentials = credentials == null ? StorageCredentialsAnonymous.ANONYMOUS : credentials;
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri());
        this.storageUri = storageUri;
    }

    protected StorageRequest<ServiceClient, Void, ServiceProperties> downloadServicePropertiesImpl(final RequestOptions options, final boolean signAsTable) {
        StorageRequest<ServiceClient, Void, ServiceProperties> getRequest = new StorageRequest<ServiceClient, Void, ServiceProperties>(options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceProperties(ServiceClient.this.credentials.transformUri(client.getEndpoint()), options, null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, context);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
                }
            }

            @Override
            public ServiceProperties preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceProperties postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceProperties storageObject) throws Exception {
                return ServicePropertiesHandler.readServicePropertiesFromStream(connection.getInputStream());
            }
        };
        return getRequest;
    }

    protected StorageRequest<ServiceClient, Void, ServiceStats> getServiceStatsImpl(final RequestOptions options, final boolean signAsTable) {
        StorageRequest<ServiceClient, Void, ServiceStats> getRequest = new StorageRequest<ServiceClient, Void, ServiceStats>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.applyLocationModeToRequest();
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceStats(ServiceClient.this.credentials.transformUri(client.getStorageUri().getUri(this.getCurrentLocation())), options, null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, context);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
                }
            }

            @Override
            public ServiceStats preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceStats postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceStats storageObject) throws Exception {
                return ServiceStatsHandler.readServiceStatsFromStream(connection.getInputStream());
            }
        };
        return getRequest;
    }

    public final StorageCredentials getCredentials() {
        return this.credentials;
    }

    public final URI getEndpoint() {
        return this.storageUri.getPrimaryUri();
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    protected boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    protected final void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    protected final void setStorageUri(StorageUri storageUri) {
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri());
        this.storageUri = storageUri;
    }

    protected StorageRequest<ServiceClient, Void, Void> uploadServicePropertiesImpl(ServiceProperties properties, final RequestOptions options, OperationContext opContext, final boolean signAsTable) throws StorageException {
        try {
            byte[] propertiesBytes = ServicePropertiesSerializer.serializeToByteArray(properties);
            final ByteArrayInputStream sendStream = new ByteArrayInputStream(propertiesBytes);
            final StreamMd5AndLength descriptor = Utility.analyzeStream(sendStream, -1L, -1L, true, true);
            StorageRequest<ServiceClient, Void, Void> putRequest = new StorageRequest<ServiceClient, Void, Void>(options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                    this.setSendStream(sendStream);
                    this.setLength(descriptor.getLength());
                    return BaseRequest.setServiceProperties(ServiceClient.this.credentials.transformUri(client.getEndpoint()), options, null, context);
                }

                @Override
                public void setHeaders(HttpURLConnection connection, Void parentObject, OperationContext context) {
                    connection.setRequestProperty("Content-MD5", descriptor.getMd5());
                }

                @Override
                public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                    if (signAsTable) {
                        StorageRequest.signTableRequest(connection, client, descriptor.getLength(), context);
                    } else {
                        StorageRequest.signBlobQueueAndFileRequest(connection, client, descriptor.getLength(), context);
                    }
                }

                @Override
                public Void preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 202) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }

                @Override
                public void recoveryAction(OperationContext context) throws IOException {
                    sendStream.reset();
                    sendStream.mark(0x10000000);
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
    }

    public abstract RequestOptions getDefaultRequestOptions();
}

