/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.tools;

import java.io.PrintStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configured;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Tool;

public abstract class CommandShell
extends Configured
implements Tool {
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private SubCommand subcommand = null;

    public abstract String getCommandUsage();

    public void setSubCommand(SubCommand cmd) {
        this.subcommand = cmd;
    }

    public void setOut(PrintStream p) {
        this.out = p;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setErr(PrintStream p) {
        this.err = p;
    }

    public PrintStream getErr() {
        return this.err;
    }

    @Override
    public int run(String[] args) throws Exception {
        int exitCode = 0;
        try {
            exitCode = this.init(args);
            if (exitCode != 0 || this.subcommand == null) {
                this.printShellUsage();
                return exitCode;
            }
            if (this.subcommand.validate()) {
                this.subcommand.execute();
            } else {
                this.printShellUsage();
                exitCode = 1;
            }
        }
        catch (Exception e) {
            this.printShellUsage();
            e.printStackTrace(this.err);
            return 1;
        }
        return exitCode;
    }

    protected abstract int init(String[] var1) throws Exception;

    protected final void printShellUsage() {
        if (this.subcommand != null) {
            this.out.println(this.subcommand.getUsage());
        } else {
            this.out.println(this.getCommandUsage());
        }
        this.out.flush();
    }

    protected abstract class SubCommand {
        protected SubCommand() {
        }

        public boolean validate() {
            return true;
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();
    }
}

