/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ResponseBuffer
extends DataOutputStream {
    public ResponseBuffer() {
        this(1024);
    }

    public ResponseBuffer(int capacity) {
        super(new FramedBuffer(capacity));
    }

    private FramedBuffer getFramedBuffer() {
        FramedBuffer buf = (FramedBuffer)this.out;
        buf.setSize(this.written);
        return buf;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.getFramedBuffer().writeTo(out);
    }

    byte[] toByteArray() {
        return this.getFramedBuffer().toByteArray();
    }

    int capacity() {
        return ((FramedBuffer)this.out).capacity();
    }

    void setCapacity(int capacity) {
        ((FramedBuffer)this.out).setCapacity(capacity);
    }

    void ensureCapacity(int capacity) {
        if (((FramedBuffer)this.out).capacity() < capacity) {
            ((FramedBuffer)this.out).setCapacity(capacity);
        }
    }

    ResponseBuffer reset() {
        this.written = 0;
        ((FramedBuffer)this.out).reset();
        return this;
    }

    private static class FramedBuffer
    extends ByteArrayOutputStream {
        private static final int FRAMING_BYTES = 4;

        FramedBuffer(int capacity) {
            super(capacity + 4);
            this.reset();
        }

        @Override
        public int size() {
            return this.count - 4;
        }

        void setSize(int size) {
            this.buf[0] = (byte)(size >>> 24 & 0xFF);
            this.buf[1] = (byte)(size >>> 16 & 0xFF);
            this.buf[2] = (byte)(size >>> 8 & 0xFF);
            this.buf[3] = (byte)(size >>> 0 & 0xFF);
        }

        int capacity() {
            return this.buf.length - 4;
        }

        void setCapacity(int capacity) {
            this.buf = Arrays.copyOf(this.buf, capacity + 4);
        }

        @Override
        public void reset() {
            this.count = 4;
            this.setSize(0);
        }
    }
}

