/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.BaseExpression;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.ExpressionFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.FilterExpression;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.Result;

final class Print
extends BaseExpression {
    private static final String[] USAGE = new String[]{"-print", "-print0"};
    private static final String[] HELP = new String[]{"Always evaluates to true. Causes the current pathname to be", "written to standard output followed by a newline. If the -print0", "expression is used then an ASCII NULL character is appended rather", "than a newline."};
    private final String suffix;

    public static void registerExpression(ExpressionFactory factory) throws IOException {
        factory.addClass(Print.class, "-print");
        factory.addClass(Print0.class, "-print0");
    }

    public Print() {
        this("\n");
    }

    private Print(String suffix) {
        this.setUsage(USAGE);
        this.setHelp(HELP);
        this.suffix = suffix;
    }

    @Override
    public Result apply(PathData item, int depth) throws IOException {
        this.getOptions().getOut().print(item.toString() + this.suffix);
        return Result.PASS;
    }

    @Override
    public boolean isAction() {
        return true;
    }

    static final class Print0
    extends FilterExpression {
        public Print0() {
            super(new Print("\u0000"));
        }
    }
}

