/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.Deque;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.BaseExpression;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.Expression;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.ExpressionFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.Result;

final class And
extends BaseExpression {
    private static final String[] USAGE = new String[]{"expression -a expression", "expression -and expression", "expression expression"};
    private static final String[] HELP = new String[]{"Logical AND operator for joining two expressions. Returns", "true if both child expressions return true. Implied by the", "juxtaposition of two expressions and so does not need to be", "explicitly specified. The second expression will not be", "applied if the first fails."};

    public static void registerExpression(ExpressionFactory factory) throws IOException {
        factory.addClass(And.class, "-a");
        factory.addClass(And.class, "-and");
    }

    public And() {
        this.setUsage(USAGE);
        this.setHelp(HELP);
    }

    @Override
    public Result apply(PathData item, int depth) throws IOException {
        Result result = Result.PASS;
        for (Expression child : this.getChildren()) {
            Result childResult = child.apply(item, -1);
            if ((result = result.combine(childResult)).isPass()) continue;
            return result;
        }
        return result;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public int getPrecedence() {
        return 200;
    }

    @Override
    public void addChildren(Deque<Expression> expressions) {
        this.addChildren(expressions, 2);
    }
}

