/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.io.InputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CanUnbuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StreamCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class StreamCapabilitiesPolicy {
    public static final String CAN_UNBUFFER_NOT_IMPLEMENTED_MESSAGE = "claims unbuffer capabilty but does not implement CanUnbuffer";
    static final Logger LOG = LoggerFactory.getLogger(StreamCapabilitiesPolicy.class);

    public static void unbuffer(InputStream in) {
        try {
            if (in instanceof StreamCapabilities && ((StreamCapabilities)((Object)in)).hasCapability("in:unbuffer")) {
                ((CanUnbuffer)((Object)in)).unbuffer();
            } else {
                LOG.debug(in.getClass().getName() + ": does not implement StreamCapabilities and the unbuffer capability");
            }
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException(in.getClass().getName() + ": " + CAN_UNBUFFER_NOT_IMPLEMENTED_MESSAGE);
        }
    }
}

