/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.org.eclipse.jetty.util;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.flink.fs.azure.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.flink.fs.azure.shaded.org.eclipse.jetty.util.log.Logger;

public class Jetty {
    private static final Logger LOG = Log.getLogger(Jetty.class);
    public static final String VERSION;
    public static final String POWERED_BY;
    public static final boolean STABLE;
    public static final String GIT_HASH;
    public static final String BUILD_TIMESTAMP;
    private static final Properties __buildProperties;

    private Jetty() {
    }

    private static String formatTimestamp(String timestamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(new Date(Long.valueOf(timestamp)));
        }
        catch (NumberFormatException e) {
            LOG.debug(e);
            return "unknown";
        }
    }

    static {
        __buildProperties = new Properties();
        try (InputStream inputStream = Jetty.class.getResourceAsStream("/org/apache/flink/fs/azure/shaded/org/eclipse/jetty/version/build.properties");){
            __buildProperties.load(inputStream);
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        GIT_HASH = __buildProperties.getProperty("buildNumber", "unknown");
        System.setProperty("jetty.git.hash", GIT_HASH);
        BUILD_TIMESTAMP = Jetty.formatTimestamp(__buildProperties.getProperty("timestamp", "unknown"));
        Package pkg = Jetty.class.getPackage();
        VERSION = pkg != null && "Eclipse.org - Jetty".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : System.getProperty("jetty.version", "9.3.z-SNAPSHOT");
        POWERED_BY = "<a href=\"http://eclipse.org/jetty\">Powered by Jetty:// " + VERSION + "</a>";
        STABLE = !VERSION.matches("^.*\\.(RC|M)[0-9]+$");
    }
}

