/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.RequestResult;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableOperation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TablePayloadFormat;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableStorageErrorDeserializer;

public final class TableServiceException
extends StorageException {
    private static final long serialVersionUID = 6037366449663934891L;
    private TableOperation operation;

    protected static TableServiceException generateTableServiceException(RequestResult res, TableOperation op, InputStream inStream, TablePayloadFormat format) {
        return new TableServiceException(res.getStatusCode(), res.getStatusMessage(), op, new InputStreamReader(inStream), format);
    }

    public TableServiceException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(errorCode, message, statusCode, extendedErrorInfo, innerException);
    }

    protected TableServiceException(int httpStatusCode, String message, TableOperation operation, Reader reader, TablePayloadFormat format) {
        super(null, message, httpStatusCode, null, null);
        this.operation = operation;
        if (reader != null) {
            try {
                this.extendedErrorInformation = TableStorageErrorDeserializer.getExtendedErrorInformation(reader, format);
                this.errorCode = this.extendedErrorInformation.getErrorCode();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public TableOperation getOperation() {
        return this.operation;
    }

    protected void setOperation(TableOperation operation) {
        this.operation = operation;
    }
}

