/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.queue;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Base64;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.queue.QueueMessageType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.queue.QueueRequestOptions;

public class CloudQueueMessage {
    private int dequeueCount;
    private Date expirationTime;
    private String id;
    private Date insertionTime;
    protected String messageContent;
    private QueueMessageType messageType;
    private Date nextVisibleTime;
    private String popReceipt;

    protected CloudQueueMessage() {
    }

    public CloudQueueMessage(byte[] content) {
        this.setMessageContent(content);
    }

    public CloudQueueMessage(String content) {
        this.setMessageContent(content);
    }

    public final int getDequeueCount() {
        return this.dequeueCount;
    }

    public final Date getExpirationTime() {
        return this.expirationTime;
    }

    public final String getId() {
        return this.id;
    }

    public final Date getInsertionTime() {
        return this.insertionTime;
    }

    public final byte[] getMessageContentAsByte() throws StorageException {
        if (Utility.isNullOrEmpty(this.messageContent)) {
            return new byte[0];
        }
        if (this.messageType == QueueMessageType.RAW_STRING) {
            try {
                return this.messageContent.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        return Base64.decode(this.messageContent);
    }

    public final String getMessageContentAsString() throws StorageException {
        if (this.messageType == QueueMessageType.RAW_STRING) {
            return this.messageContent;
        }
        if (Utility.isNullOrEmpty(this.messageContent)) {
            return null;
        }
        try {
            return new String(Base64.decode(this.messageContent), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    protected final String getMessageContentForTransfer(boolean shouldEncodeMessage, QueueRequestOptions options) throws StorageException {
        String result = null;
        if (options.getEncryptionPolicy() != null) {
            String encryptedMessageString = options.getEncryptionPolicy().encryptMessage(this.getMessageContentAsByte());
            if ((long)encryptedMessageString.length() > 65536L) {
                throw new IllegalArgumentException(String.format("Encrypted Messages cannot be larger than {0} bytes. Please note that encrypting queue messages can increase their size.", 65536L));
            }
            return encryptedMessageString;
        }
        result = this.messageType == QueueMessageType.RAW_STRING && shouldEncodeMessage ? Base64.encode(this.getMessageContentAsByte()) : this.messageContent;
        if (result != null && (long)result.length() > 65536L) {
            throw new IllegalArgumentException(String.format("The message size cannot be larger than %s bytes.", 65536L));
        }
        return result;
    }

    public final String getMessageId() {
        return this.id;
    }

    protected final QueueMessageType getMessageType() {
        return this.messageType;
    }

    public final Date getNextVisibleTime() {
        return this.nextVisibleTime;
    }

    public final String getPopReceipt() {
        return this.popReceipt;
    }

    protected final void setDequeueCount(int dequeueCount) {
        this.dequeueCount = dequeueCount;
    }

    protected final void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    protected final void setInsertionTime(Date insertionTime) {
        this.insertionTime = insertionTime;
    }

    public final void setMessageContent(byte[] content) {
        Utility.assertNotNull("content", content);
        this.messageContent = Base64.encode(content);
        this.messageType = QueueMessageType.BASE_64_ENCODED;
    }

    public final void setMessageContent(String content) {
        this.messageContent = content;
        this.messageType = QueueMessageType.RAW_STRING;
    }

    protected final void setMessageId(String id) {
        this.id = id;
    }

    protected final void setMessageType(QueueMessageType messageType) {
        this.messageType = messageType;
    }

    protected final void setNextVisibleTime(Date nextVisibleTime) {
        this.nextVisibleTime = nextVisibleTime;
    }

    protected final void setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
    }
}

