/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.core.HTraceConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.commons.logging.Log;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.commons.logging.LogFactory;

public final class TracerId {
    private static final Log LOG = LogFactory.getLog(TracerId.class);
    public static final String TRACER_ID_KEY = "tracer.id";
    private static final String DEFAULT_TRACER_ID = "%{tname}/%{ip}";
    private final String tracerName;
    private final String tracerId;

    public TracerId(HTraceConfiguration conf, String tracerName) {
        this.tracerName = tracerName;
        String fmt = conf.get(TRACER_ID_KEY, DEFAULT_TRACER_ID);
        StringBuilder bld = new StringBuilder();
        StringBuilder varBld = null;
        boolean escaping = false;
        int varSeen = 0;
        int len = fmt.length();
        block4: for (int i = 0; i < len; ++i) {
            char c = fmt.charAt(i);
            if (c == '\\' && !escaping) {
                escaping = true;
                continue;
            }
            switch (varSeen) {
                case 0: {
                    if (c == '%' && !escaping) {
                        varSeen = 1;
                        continue block4;
                    }
                    escaping = false;
                    varSeen = 0;
                    bld.append(c);
                    continue block4;
                }
                case 1: {
                    if (c == '{' && !escaping) {
                        varSeen = 2;
                        varBld = new StringBuilder();
                        continue block4;
                    }
                    escaping = false;
                    varSeen = 0;
                    bld.append("%").append(c);
                    continue block4;
                }
                default: {
                    if (c == '}' && !escaping) {
                        String var = varBld.toString();
                        bld.append(this.processShellVar(var));
                        varBld = null;
                        varSeen = 0;
                        continue block4;
                    }
                    escaping = false;
                    varBld.append(c);
                    ++varSeen;
                }
            }
        }
        if (varSeen > 0) {
            LOG.warn("Unterminated process ID substitution variable at the end of format string " + fmt);
        }
        this.tracerId = bld.toString();
        if (LOG.isTraceEnabled()) {
            LOG.trace("ProcessID(fmt=" + fmt + "): computed process ID of \"" + this.tracerId + "\"");
        }
    }

    private String processShellVar(String var) {
        if (var.equals("tname")) {
            return this.tracerName;
        }
        if (var.equals("pname")) {
            return TracerId.getProcessName();
        }
        if (var.equals("ip")) {
            return TracerId.getBestIpString();
        }
        if (var.equals("pid")) {
            return Long.valueOf(TracerId.getOsPid()).toString();
        }
        LOG.warn("unknown ProcessID variable " + var);
        return "";
    }

    static String getProcessName() {
        String cmdLine = System.getProperty("sun.java.command");
        if (cmdLine != null && !cmdLine.isEmpty()) {
            String fullClassName = cmdLine.split("\\s+")[0];
            String[] classParts = fullClassName.split("\\.");
            cmdLine = classParts[classParts.length - 1];
        }
        return cmdLine == null || cmdLine.isEmpty() ? "Unknown" : cmdLine;
    }

    static String getBestIpString() {
        Enumeration<NetworkInterface> ifaces;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOG.error("Error getting network interfaces", e);
            return "127.0.0.1";
        }
        TreeSet<String> siteLocalCandidates = new TreeSet<String>();
        TreeSet<String> candidates = new TreeSet<String>();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr.isSiteLocalAddress()) {
                    siteLocalCandidates.add(addr.getHostAddress());
                    continue;
                }
                candidates.add(addr.getHostAddress());
            }
        }
        if (!siteLocalCandidates.isEmpty()) {
            return (String)siteLocalCandidates.first();
        }
        if (!candidates.isEmpty()) {
            return (String)candidates.first();
        }
        return "127.0.0.1";
    }

    static long getOsPid() {
        if (System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("windows")) {
            return TracerId.getOsPidFromManagementFactory();
        }
        return TracerId.getOsPidFromShellPpid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getOsPidFromShellPpid() {
        Process p = null;
        StringBuilder sb = new StringBuilder();
        try {
            p = new ProcessBuilder("/usr/bin/env", "sh", "-c", "echo $PPID").redirectErrorStream(true).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line.trim());
            }
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                throw new IOException("Process exited with error code " + Integer.valueOf(exitVal).toString());
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while getting operating system pid from the shell.", e);
            long l = 0L;
            return l;
        }
        catch (IOException e) {
            LOG.error("Error getting operating system pid from the shell.", e);
            long l = 0L;
            return l;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        try {
            return Long.parseLong(sb.toString());
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing operating system pid from the shell.", e);
            return 0L;
        }
    }

    private static long getOsPidFromManagementFactory() {
        try {
            return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to get the operating system process ID from the name of the managed bean for the JVM.", e);
            return 0L;
        }
    }

    public String get() {
        return this.tracerId;
    }
}

