/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.core;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.core.HTraceConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.core.Sampler;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.commons.logging.Log;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.commons.logging.LogFactory;

public class ProbabilitySampler
extends Sampler {
    private static final Log LOG = LogFactory.getLog(ProbabilitySampler.class);
    public final double threshold;
    public static final String SAMPLER_FRACTION_CONF_KEY = "sampler.fraction";

    public ProbabilitySampler(HTraceConfiguration conf) {
        this.threshold = Double.parseDouble(conf.get(SAMPLER_FRACTION_CONF_KEY));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created new ProbabilitySampler with threshold = " + this.threshold + ".");
        }
    }

    @Override
    public boolean next() {
        return ThreadLocalRandom.current().nextDouble() < this.threshold;
    }
}

