/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IndexedSortable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IndexedSorter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HeapSort
implements IndexedSorter {
    private static void downHeap(IndexedSortable s, int b, int i, int N) {
        int idx = i << 1;
        while (idx < N) {
            if (idx + 1 < N && s.compare(b + idx, b + idx + 1) < 0) {
                if (s.compare(b + i, b + idx + 1) >= 0) {
                    return;
                }
                s.swap(b + i, b + idx + 1);
                i = idx + 1;
            } else if (s.compare(b + i, b + idx) < 0) {
                s.swap(b + i, b + idx);
                i = idx;
            } else {
                return;
            }
            idx = i << 1;
        }
    }

    @Override
    public void sort(IndexedSortable s, int p, int r) {
        this.sort(s, p, r, null);
    }

    @Override
    public void sort(IndexedSortable s, int p, int r, Progressable rep) {
        int t;
        int i;
        int N = r - p;
        for (i = t = Integer.highestOneBit(N); i > 1; i >>>= 1) {
            for (int j = i >>> 1; j < i; ++j) {
                HeapSort.downHeap(s, p - 1, j, N + 1);
            }
            if (null == rep) continue;
            rep.progress();
        }
        for (i = r - 1; i > p; --i) {
            s.swap(p, i);
            HeapSort.downHeap(s, p - 1, 1, i - p + 1);
        }
    }
}

