/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public interface RetryPolicy {
    public RetryAction shouldRetry(Exception var1, int var2, int var3, boolean var4) throws Exception;

    @InterfaceStability.Evolving
    public static class RetryAction {
        public static final RetryAction FAIL = new RetryAction(RetryDecision.FAIL);
        public static final RetryAction RETRY = new RetryAction(RetryDecision.RETRY);
        public static final RetryAction FAILOVER_AND_RETRY = new RetryAction(RetryDecision.FAILOVER_AND_RETRY);
        public final RetryDecision action;
        public final long delayMillis;
        public final String reason;

        public RetryAction(RetryDecision action) {
            this(action, 0L, null);
        }

        public RetryAction(RetryDecision action, long delayTime) {
            this(action, delayTime, null);
        }

        public RetryAction(RetryDecision action, long delayTime, String reason) {
            this.action = action;
            this.delayMillis = delayTime;
            this.reason = reason;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(action=" + (Object)((Object)this.action) + ", delayMillis=" + this.delayMillis + ", reason=" + this.reason + ")";
        }

        public static enum RetryDecision {
            FAIL,
            RETRY,
            FAILOVER_AND_RETRY;

        }
    }
}

