/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobRequestOptions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Seekable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.NativeAzureFileSystemHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.StorageInterface;

final class BlockBlobInputStream
extends InputStream
implements Seekable {
    private final StorageInterface.CloudBlockBlobWrapper blob;
    private final BlobRequestOptions options;
    private final OperationContext opContext;
    private InputStream blobInputStream = null;
    private int minimumReadSizeInBytes = 0;
    private long streamPositionAfterLastRead = -1L;
    private long streamPosition = 0L;
    private long streamLength = 0L;
    private boolean closed = false;
    private byte[] streamBuffer;
    private int streamBufferPosition;
    private int streamBufferLength;

    BlockBlobInputStream(StorageInterface.CloudBlockBlobWrapper blob, BlobRequestOptions options, OperationContext opContext) throws IOException {
        this.blob = blob;
        this.options = options;
        this.opContext = opContext;
        this.minimumReadSizeInBytes = blob.getStreamMinimumReadSizeInBytes();
        try {
            this.blobInputStream = blob.openInputStream(options, opContext);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        this.streamLength = blob.getProperties().getLength();
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    private void resetStreamBuffer() {
        this.streamBufferPosition = 0;
        this.streamBufferLength = 0;
    }

    @Override
    public synchronized long getPos() throws IOException {
        this.checkState();
        return this.streamBuffer != null ? this.streamPosition - (long)this.streamBufferLength + (long)this.streamBufferPosition : this.streamPosition;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        this.checkState();
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        if (pos > this.streamLength) {
            throw new EOFException("Attempted to seek or read past the end of the file " + pos);
        }
        long offset = pos - this.getPos();
        if (offset == 0L) {
            return;
        }
        if (offset > 0L) {
            if (this.skip(offset) != offset) {
                throw new EOFException("End of file reached before reading fully.");
            }
            return;
        }
        if (this.streamBuffer != null) {
            if ((long)this.streamBufferPosition + offset >= 0L) {
                this.streamBufferPosition = (int)((long)this.streamBufferPosition + offset);
            } else {
                this.resetStreamBuffer();
                this.streamPosition = pos;
            }
        } else {
            this.streamPosition = pos;
        }
        this.closeBlobInputStream();
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkState();
        if (this.blobInputStream != null) {
            return this.blobInputStream.available();
        }
        return this.streamBuffer == null ? 0 : this.streamBufferLength - this.streamBufferPosition;
    }

    private void closeBlobInputStream() throws IOException {
        if (this.blobInputStream != null) {
            try {
                this.blobInputStream.close();
            }
            finally {
                this.blobInputStream = null;
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.closeBlobInputStream();
        this.streamBuffer = null;
        this.streamBufferPosition = 0;
        this.streamBufferLength = 0;
    }

    private int doNetworkRead(byte[] buffer, int offset, int len) throws IOException {
        MemoryOutputStream outputStream;
        boolean needToCopy = false;
        if (this.streamPositionAfterLastRead == this.streamPosition) {
            if (this.streamBuffer == null) {
                this.streamBuffer = new byte[(int)Math.min((long)this.minimumReadSizeInBytes, this.streamLength)];
            }
            this.resetStreamBuffer();
            outputStream = new MemoryOutputStream(this.streamBuffer, this.streamBufferPosition, this.streamBuffer.length);
            needToCopy = true;
        } else {
            outputStream = new MemoryOutputStream(buffer, offset, len);
        }
        long bytesToRead = Math.min((long)this.minimumReadSizeInBytes, Math.min((long)outputStream.capacity(), this.streamLength - this.streamPosition));
        try {
            this.blob.downloadRange(this.streamPosition, bytesToRead, outputStream, this.options, this.opContext);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        int bytesRead = outputStream.size();
        if (bytesRead > 0) {
            this.streamPosition += (long)bytesRead;
            this.streamPositionAfterLastRead = this.streamPosition;
            int count = Math.min(bytesRead, len);
            if (needToCopy) {
                this.streamBufferLength = bytesRead;
                System.arraycopy(this.streamBuffer, this.streamBufferPosition, buffer, offset, count);
                this.streamBufferPosition += count;
            }
            return count;
        }
        throw new EOFException("End of stream reached unexpectedly.");
    }

    @Override
    public synchronized int read(byte[] b, int offset, int len) throws IOException {
        this.checkState();
        NativeAzureFileSystemHelper.validateReadArgs(b, offset, len);
        if (this.blobInputStream != null) {
            int numberOfBytesRead = this.blobInputStream.read(b, offset, len);
            this.streamPosition += (long)numberOfBytesRead;
            return numberOfBytesRead;
        }
        if (offset < 0 || len < 0 || len > b.length - offset) {
            throw new IndexOutOfBoundsException("read arguments out of range");
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        int available = this.available();
        if (available > 0) {
            bytesRead = Math.min(available, len);
            System.arraycopy(this.streamBuffer, this.streamBufferPosition, b, offset, bytesRead);
            this.streamBufferPosition += bytesRead;
        }
        if (len == bytesRead) {
            return len;
        }
        if (this.streamPosition >= this.streamLength) {
            return bytesRead > 0 ? bytesRead : -1;
        }
        return bytesRead + this.doNetworkRead(b, offset += bytesRead, len -= bytesRead);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int numberOfBytesRead = this.read(buffer, 0, 1);
        return numberOfBytesRead < 1 ? -1 : buffer[0];
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.checkState();
        if (this.blobInputStream != null) {
            long skipped = this.blobInputStream.skip(n);
            this.streamPosition += skipped;
            return skipped;
        }
        if (n < 0L || n > this.streamLength - this.getPos()) {
            throw new IndexOutOfBoundsException("skip range");
        }
        if (this.streamBuffer != null) {
            if (n < (long)(this.streamBufferLength - this.streamBufferPosition)) {
                this.streamBufferPosition += (int)n;
            } else {
                this.streamPosition = this.getPos() + n;
                this.resetStreamBuffer();
            }
        } else {
            this.streamPosition += n;
        }
        return n;
    }

    static class MemoryOutputStream
    extends OutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int length;
        private int writePosition;

        MemoryOutputStream(byte[] buffer, int offset, int length) {
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if (offset < 0 || length < 0 || length > buffer.length - offset) {
                throw new IndexOutOfBoundsException("offset out of range of buffer");
            }
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
            this.writePosition = offset;
        }

        public synchronized int size() {
            return this.writePosition - this.offset;
        }

        public synchronized int capacity() {
            return this.length;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.size() > this.length - 1) {
                throw new IOException("No space for more writes");
            }
            this.buffer[this.writePosition++] = (byte)b;
        }

        @Override
        public synchronized void write(byte[] b, int off, int length) throws IOException {
            if (b == null) {
                throw new NullPointerException("Null buffer argument");
            }
            if (off < 0 || length < 0 || length > b.length - off) {
                throw new IndexOutOfBoundsException("array write offset");
            }
            System.arraycopy(b, off, this.buffer, this.writePosition, length);
            this.writePosition += length;
        }
    }
}

