/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.DU;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.WindowsGetSpaceUsed;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GetSpaceUsed {
    public long getUsed() throws IOException;

    public static final class Builder {
        static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        static final String CLASSNAME_KEY = "fs.getspaceused.classname";
        static final String JITTER_KEY = "fs.getspaceused.jitterMillis";
        static final long DEFAULT_JITTER = TimeUnit.MINUTES.toMillis(1L);
        private Configuration conf;
        private Class<? extends GetSpaceUsed> klass = null;
        private File path = null;
        private Long interval = null;
        private Long jitter = null;
        private Long initialUsed = null;

        public Configuration getConf() {
            return this.conf;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public long getInterval() {
            if (this.interval != null) {
                return this.interval;
            }
            long result = 600000L;
            if (this.conf == null) {
                return result;
            }
            return this.conf.getLong("fs.du.interval", result);
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Class<? extends GetSpaceUsed> getKlass() {
            if (this.klass != null) {
                return this.klass;
            }
            Class result = null;
            result = Shell.WINDOWS ? WindowsGetSpaceUsed.class : DU.class;
            if (this.conf == null) {
                return result;
            }
            return this.conf.getClass(CLASSNAME_KEY, result, GetSpaceUsed.class);
        }

        public Builder setKlass(Class<? extends GetSpaceUsed> klass) {
            this.klass = klass;
            return this;
        }

        public File getPath() {
            return this.path;
        }

        public Builder setPath(File path) {
            this.path = path;
            return this;
        }

        public long getInitialUsed() {
            if (this.initialUsed == null) {
                return -1L;
            }
            return this.initialUsed;
        }

        public Builder setInitialUsed(long initialUsed) {
            this.initialUsed = initialUsed;
            return this;
        }

        public long getJitter() {
            if (this.jitter == null) {
                Configuration configuration = this.conf;
                if (configuration == null) {
                    return DEFAULT_JITTER;
                }
                return configuration.getLong(JITTER_KEY, DEFAULT_JITTER);
            }
            return this.jitter;
        }

        public Builder setJitter(Long jit) {
            this.jitter = jit;
            return this;
        }

        public GetSpaceUsed build() throws IOException {
            GetSpaceUsed getSpaceUsed = null;
            try {
                Constructor<? extends GetSpaceUsed> cons = this.getKlass().getConstructor(Builder.class);
                getSpaceUsed = cons.newInstance(this);
            }
            catch (InstantiationException e) {
                LOG.warn("Error trying to create an instance of " + this.getKlass(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Error trying to create " + this.getKlass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.warn("Error trying to create " + this.getKlass(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Doesn't look like the class " + this.getKlass() + " have the needed constructor", (Throwable)e);
            }
            if (getSpaceUsed == null) {
                getSpaceUsed = Shell.WINDOWS ? new WindowsGetSpaceUsed(this) : new DU(this);
            }
            if (getSpaceUsed instanceof CachingGetSpaceUsed) {
                ((CachingGetSpaceUsed)getSpaceUsed).init();
            }
            return getSpaceUsed;
        }
    }
}

