/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EntityProperty;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableEntity;

public class TableResult {
    private Object result;
    private int httpStatusCode = -1;
    private String etag;
    private HashMap<String, EntityProperty> properties;

    public TableResult() {
    }

    public TableResult(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getEtag() {
        return this.etag;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public HashMap<String, EntityProperty> getProperties() {
        return this.properties;
    }

    public Object getResult() {
        return this.result;
    }

    public <T> T getResultAsType() {
        return (T)this.getResult();
    }

    protected void setEtag(String etag) {
        this.etag = etag;
    }

    protected void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    protected void setProperties(HashMap<String, EntityProperty> properties) {
        this.properties = properties;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    protected void updateResultObject(TableEntity ent) throws UnsupportedEncodingException {
        this.result = ent;
        ent.setEtag(this.etag);
        if (this.etag != null) {
            ent.setTimestamp(TableResult.parseETagForTimestamp(this.etag));
        }
    }

    private static Date parseETagForTimestamp(String etag) throws UnsupportedEncodingException {
        if (etag.startsWith("W/")) {
            etag = etag.substring(2);
        }
        etag = etag.substring("\"datetime'".length(), etag.length() - 2);
        etag = URLDecoder.decode(etag, "UTF-8");
        return Utility.parseDate(etag);
    }
}

