/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlockEntry;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlockSearchMode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

final class BlockEntryListSerializer {
    BlockEntryListSerializer() {
    }

    public static byte[] writeBlockListToStream(Iterable<BlockEntry> blockList, OperationContext opContext) throws XMLStreamException, StorageException {
        StringWriter outWriter = new StringWriter();
        XMLStreamWriter xmlw = Utility.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("BlockList");
        for (BlockEntry block : blockList) {
            if (block.getSearchMode() == BlockSearchMode.COMMITTED) {
                xmlw.writeStartElement("Committed");
            } else if (block.getSearchMode() == BlockSearchMode.UNCOMMITTED) {
                xmlw.writeStartElement("Uncommitted");
            } else if (block.getSearchMode() == BlockSearchMode.LATEST) {
                xmlw.writeStartElement("Latest");
            }
            xmlw.writeCharacters(block.getId());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }
}

