/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.formats.avro.AvroRecordInputFormatTest;
import org.apache.flink.formats.avro.generated.Fixed16;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.InjectMiniCluster;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.test.util.TestEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class AvroTypeExtractionTest {
    private static final int PARALLELISM = 4;
    @RegisterExtension
    private static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());
    private File inFile;
    private String resultPath;
    private String expected;

    AvroTypeExtractionTest() {
    }

    @BeforeEach
    public void before(@TempDir java.nio.file.Path tmpDir) throws Exception {
        this.resultPath = tmpDir.resolve("out").toUri().toString();
        this.inFile = tmpDir.resolve("in.avro").toFile();
        AvroRecordInputFormatTest.writeTestFile(this.inFile);
    }

    @AfterEach
    public void after() throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSimpleAvroRead(boolean useMiniCluster, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        MapOperator usersDS = env.createInput((InputFormat)users).map((MapFunction & Serializable)value -> value);
        usersDS.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        this.expected = "{\"name\": \"Alyssa\", \"favorite_number\": 256, \"favorite_color\": null, \"type_long_test\": null, \"type_double_test\": 123.45, \"type_null_test\": null, \"type_bool_test\": true, \"type_array_string\": [\"ELEMENT 1\", \"ELEMENT 2\"], \"type_array_boolean\": [true, false], \"type_nullable_array\": null, \"type_enum\": \"GREEN\", \"type_map\": {\"KEY 2\": 17554, \"KEY 1\": 8546456}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}, \"type_bytes\": \"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\", \"type_date\": \"2014-03-01\", \"type_time_millis\": \"12:12:12\", \"type_time_micros\": \"00:00:00.123456\", \"type_timestamp_millis\": \"2014-03-01T12:12:12.321Z\", \"type_timestamp_micros\": \"1970-01-01T00:00:00.123456Z\", \"type_decimal_bytes\": \"\\u0007\u00d0\", \"type_decimal_fixed\": [7, -48]}\n{\"name\": \"Charlie\", \"favorite_number\": null, \"favorite_color\": \"blue\", \"type_long_test\": 1337, \"type_double_test\": 1.337, \"type_null_test\": null, \"type_bool_test\": false, \"type_array_string\": [], \"type_array_boolean\": [], \"type_nullable_array\": null, \"type_enum\": \"RED\", \"type_map\": {}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}, \"type_bytes\": \"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\", \"type_date\": \"2014-03-01\", \"type_time_millis\": \"12:12:12\", \"type_time_micros\": \"00:00:00.123456\", \"type_timestamp_millis\": \"2014-03-01T12:12:12.321Z\", \"type_timestamp_micros\": \"1970-01-01T00:00:00.123456Z\", \"type_decimal_bytes\": \"\\u0007\u00d0\", \"type_decimal_fixed\": [7, -48]}\n";
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSerializeWithAvro(boolean useMiniCluster, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        env.getConfig().getSerializerConfig().setForceAvro(true);
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        MapOperator usersDS = env.createInput((InputFormat)users).map((MapFunction & Serializable)value -> {
            HashMap<CharSequence, Long> ab = new HashMap<CharSequence, Long>(1);
            ab.put("hehe", 12L);
            value.setTypeMap(ab);
            return value;
        });
        usersDS.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        this.expected = "{\"name\": \"Alyssa\", \"favorite_number\": 256, \"favorite_color\": null, \"type_long_test\": null, \"type_double_test\": 123.45, \"type_null_test\": null, \"type_bool_test\": true, \"type_array_string\": [\"ELEMENT 1\", \"ELEMENT 2\"], \"type_array_boolean\": [true, false], \"type_nullable_array\": null, \"type_enum\": \"GREEN\", \"type_map\": {\"hehe\": 12}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}, \"type_bytes\": \"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\", \"type_date\": \"2014-03-01\", \"type_time_millis\": \"12:12:12\", \"type_time_micros\": \"00:00:00.123456\", \"type_timestamp_millis\": \"2014-03-01T12:12:12.321Z\", \"type_timestamp_micros\": \"1970-01-01T00:00:00.123456Z\", \"type_decimal_bytes\": \"\\u0007\u00d0\", \"type_decimal_fixed\": [7, -48]}\n{\"name\": \"Charlie\", \"favorite_number\": null, \"favorite_color\": \"blue\", \"type_long_test\": 1337, \"type_double_test\": 1.337, \"type_null_test\": null, \"type_bool_test\": false, \"type_array_string\": [], \"type_array_boolean\": [], \"type_nullable_array\": null, \"type_enum\": \"RED\", \"type_map\": {\"hehe\": 12}, \"type_fixed\": null, \"type_union\": null, \"type_nested\": {\"num\": 239, \"street\": \"Baker Street\", \"city\": \"London\", \"state\": \"London\", \"zip\": \"NW1 6XE\"}, \"type_bytes\": \"\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\\u0000\", \"type_date\": \"2014-03-01\", \"type_time_millis\": \"12:12:12\", \"type_time_micros\": \"00:00:00.123456\", \"type_timestamp_millis\": \"2014-03-01T12:12:12.321Z\", \"type_timestamp_micros\": \"1970-01-01T00:00:00.123456Z\", \"type_decimal_bytes\": \"\\u0007\u00d0\", \"type_decimal_fixed\": [7, -48]}\n";
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testKeySelection(boolean useMiniCluster, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        env.getConfig().enableObjectReuse();
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        SingleInputUdfOperator res = usersDS.groupBy(new String[]{"name"}).reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {
            for (User u : values) {
                out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
            }
        }).returns(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}));
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Alyssa,1)\n(Charlie,1)\n";
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testWithAvroGenericSer(boolean useMiniCluster, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        env.getConfig().getSerializerConfig().setForceAvro(true);
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        SingleInputUdfOperator res = usersDS.groupBy((KeySelector & Serializable)value -> String.valueOf(value.getName())).reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {
            for (User u : values) {
                out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
            }
        }).returns(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}));
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Charlie,1)\n(Alyssa,1)\n";
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testWithKryoGenericSer(boolean useMiniCluster, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        env.getConfig().getSerializerConfig().setForceKryo(true);
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        SingleInputUdfOperator res = usersDS.groupBy((KeySelector & Serializable)value -> String.valueOf(value.getName())).reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {
            for (User u : values) {
                out.collect((Object)new Tuple2((Object)u.getName().toString(), (Object)1));
            }
        }).returns(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}));
        res.writeAsText(this.resultPath);
        env.execute("Avro Key selection");
        this.expected = "(Charlie,1)\n(Alyssa,1)\n";
    }

    private static Stream<Arguments> testField() {
        return Arrays.stream(new Boolean[]{true, false}).flatMap(env -> Stream.of(Arguments.of((Object[])new Object[]{env, "name"}), Arguments.of((Object[])new Object[]{env, "type_enum"}), Arguments.of((Object[])new Object[]{env, "type_double_test"})));
    }

    @ParameterizedTest
    @MethodSource(value={"testField"})
    void testField(boolean useMiniCluster, String fieldName, @InjectMiniCluster MiniCluster miniCluster) throws Exception {
        ExecutionEnvironment env = AvroTypeExtractionTest.getExecutionEnvironment(useMiniCluster, miniCluster);
        Path in = new Path(this.inFile.getAbsoluteFile().toURI());
        AvroInputFormat users = new AvroInputFormat(in, User.class);
        DataSource usersDS = env.createInput((InputFormat)users);
        SingleInputUdfOperator res = usersDS.groupBy(new String[]{fieldName}).reduceGroup((GroupReduceFunction & Serializable)(values, out) -> {
            for (User u : values) {
                out.collect(u.get(fieldName));
            }
        }).returns(Object.class);
        res.writeAsText(this.resultPath);
        env.execute("Simple Avro read job");
        ExecutionConfig ec = env.getConfig();
        Assertions.assertThat((Collection)ec.getRegisteredKryoTypes()).contains((Object[])new Class[]{Fixed16.class});
        switch (fieldName) {
            case "name": {
                this.expected = "Alyssa\nCharlie";
                break;
            }
            case "type_enum": {
                this.expected = "GREEN\nRED\n";
                break;
            }
            case "type_double_test": {
                this.expected = "123.45\n1.337\n";
                break;
            }
            default: {
                Assertions.fail((String)"Unknown field");
            }
        }
    }

    private static ExecutionEnvironment getExecutionEnvironment(boolean useMiniCluster, MiniCluster miniCluster) {
        return useMiniCluster ? new TestEnvironment(miniCluster, 4, false) : new CollectionTestEnvironment();
    }
}

