/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.AvroSerializerSnapshot;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class AvroSerializerSnapshotTest {
    private static final int[] PAST_VERSIONS = new int[]{2};
    private static final Schema FIRST_NAME = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"name").namespace("org.apache.flink")).fields().requiredString("first").endRecord();
    private static final Schema FIRST_REQUIRED_LAST_OPTIONAL = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"name").namespace("org.apache.flink")).fields().requiredString("first").optionalString("last").endRecord();
    private static final Schema BOTH_REQUIRED = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"name").namespace("org.apache.flink")).fields().requiredString("first").requiredString("last").endRecord();

    AvroSerializerSnapshotTest() {
    }

    @Test
    void sameSchemaShouldBeCompatibleAsIs() {
        Assertions.assertThat((Object)AvroSerializerSnapshot.resolveSchemaCompatibility((Schema)FIRST_NAME, (Schema)FIRST_NAME)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void removingAnOptionalFieldsIsCompatibleAsIs() {
        Assertions.assertThat((Object)AvroSerializerSnapshot.resolveSchemaCompatibility((Schema)FIRST_REQUIRED_LAST_OPTIONAL, (Schema)FIRST_NAME)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAfterMigration()));
    }

    @Test
    void addingAnOptionalFieldsIsCompatibleAsIs() {
        Assertions.assertThat((Object)AvroSerializerSnapshot.resolveSchemaCompatibility((Schema)FIRST_NAME, (Schema)FIRST_REQUIRED_LAST_OPTIONAL)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAfterMigration()));
    }

    @Test
    void addingARequiredMakesSerializersIncompatible() {
        Assertions.assertThat((Object)AvroSerializerSnapshot.resolveSchemaCompatibility((Schema)FIRST_REQUIRED_LAST_OPTIONAL, (Schema)BOTH_REQUIRED)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isIncompatible()));
    }

    @Test
    void anAvroSnapshotIsCompatibleWithItsOriginatingSerializer() {
        AvroSerializer serializer = new AvroSerializer(GenericRecord.class, FIRST_REQUIRED_LAST_OPTIONAL);
        TypeSerializerSnapshot snapshot = serializer.snapshotConfiguration();
        Assertions.assertThat((Object)serializer.snapshotConfiguration().resolveSchemaCompatibility(snapshot)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void anAvroSnapshotIsCompatibleAfterARoundTrip() throws IOException {
        AvroSerializer serializer = new AvroSerializer(GenericRecord.class, FIRST_REQUIRED_LAST_OPTIONAL);
        AvroSerializerSnapshot restored = AvroSerializerSnapshotTest.roundTrip(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)serializer.snapshotConfiguration().resolveSchemaCompatibility(restored)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void anAvroSpecificRecordIsCompatibleAfterARoundTrip() throws IOException {
        AvroSerializer serializer = new AvroSerializer(User.class);
        AvroSerializerSnapshot restored = AvroSerializerSnapshotTest.roundTrip(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)serializer.snapshotConfiguration().resolveSchemaCompatibility(restored)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void aPojoIsCompatibleAfterARoundTrip() throws IOException {
        AvroSerializer serializer = new AvroSerializer(Pojo.class);
        AvroSerializerSnapshot restored = AvroSerializerSnapshotTest.roundTrip(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)serializer.snapshotConfiguration().resolveSchemaCompatibility(restored)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void aLargeSchemaAvroSnapshotIsCompatibleAfterARoundTrip() throws IOException {
        int thresholdSize = 65535;
        StringBuilder schemaField = new StringBuilder(thresholdSize);
        for (int i = 0; i <= thresholdSize; ++i) {
            schemaField.append('a');
        }
        Schema largeSchema = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"name").namespace("org.apache.flink")).fields().requiredString(schemaField.toString()).endRecord();
        AvroSerializer serializer = new AvroSerializer(GenericRecord.class, largeSchema);
        AvroSerializerSnapshot restored = AvroSerializerSnapshotTest.roundTrip(serializer.snapshotConfiguration());
        Assertions.assertThat((Object)serializer.snapshotConfiguration().resolveSchemaCompatibility(restored)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void recordSerializedShouldBeDeserializeWithTheResortedSerializer() throws IOException {
        User user = TestDataGenerator.generateRandomUser(new Random());
        AvroSerializer originalSerializer = new AvroSerializer(User.class);
        ByteBuffer serializedUser = AvroSerializerSnapshotTest.serialize(originalSerializer, user);
        TypeSerializer restoredSerializer = originalSerializer.snapshotConfiguration().restoreSerializer();
        User restoredUser = (User)((Object)AvroSerializerSnapshotTest.deserialize(restoredSerializer, serializedUser));
        Assertions.assertThat((Comparable)((Object)restoredUser)).isEqualTo((Object)user);
    }

    @Test
    void validSchemaEvaluationShouldResultInCRequiresMigration() {
        AvroSerializer originalSerializer = new AvroSerializer(GenericRecord.class, FIRST_NAME);
        AvroSerializer newSerializer = new AvroSerializer(GenericRecord.class, FIRST_REQUIRED_LAST_OPTIONAL);
        TypeSerializerSnapshot originalSnapshot = originalSerializer.snapshotConfiguration();
        Assertions.assertThat((Object)newSerializer.snapshotConfiguration().resolveSchemaCompatibility(originalSnapshot)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAfterMigration()));
    }

    @Test
    void nonValidSchemaEvaluationShouldResultInCompatibleSerializers() {
        AvroSerializer originalSerializer = new AvroSerializer(GenericRecord.class, FIRST_REQUIRED_LAST_OPTIONAL);
        AvroSerializer newSerializer = new AvroSerializer(GenericRecord.class, BOTH_REQUIRED);
        TypeSerializerSnapshot originalSnapshot = originalSerializer.snapshotConfiguration();
        Assertions.assertThat((Object)newSerializer.snapshotConfiguration().resolveSchemaCompatibility(originalSnapshot)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isIncompatible()));
    }

    @Test
    public void changingFromGenericToSpecificWithCompatibleSchemaShouldResultInCompatibleSerializers() {
        AvroSerializer generic = new AvroSerializer(GenericRecord.class, User.SCHEMA$);
        TypeSerializerSnapshot genericSnapshot = generic.snapshotConfiguration();
        AvroSerializer specificSerializer = new AvroSerializer(User.class);
        specificSerializer.snapshotConfiguration();
        Assertions.assertThat((Object)specificSerializer.snapshotConfiguration().resolveSchemaCompatibility(genericSnapshot)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
    }

    @Test
    void restorePastSnapshots() throws IOException {
        for (int pastVersion : PAST_VERSIONS) {
            AvroSerializer currentSerializer = new AvroSerializer(GenericRecord.class, Address.getClassSchema());
            DataInputDeserializer in = new DataInputDeserializer(Files.readAllBytes(this.getSerializerSnapshotFilePath(pastVersion)));
            TypeSerializerSnapshot restored = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)in, (ClassLoader)AvroSerializer.class.getClassLoader());
            Assertions.assertThat((Object)currentSerializer.snapshotConfiguration().resolveSchemaCompatibility(restored)).is((Condition)HamcrestCondition.matching((Matcher)TypeSerializerMatchers.isCompatibleAsIs()));
        }
    }

    @Disabled
    @Test
    void writeCurrentVersionSnapshot() throws IOException {
        AvroSerializer serializer = new AvroSerializer(GenericRecord.class, Address.getClassSchema());
        DataOutputSerializer out = new DataOutputSerializer(1024);
        TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)out, (TypeSerializerSnapshot)serializer.snapshotConfiguration());
        Path snapshotPath = this.getSerializerSnapshotFilePath(new AvroSerializerSnapshot().getCurrentVersion());
        Files.write(snapshotPath, out.getCopyOfBuffer(), new OpenOption[0]);
    }

    private Path getSerializerSnapshotFilePath(int version) {
        return Paths.get(System.getProperty("user.dir") + "/src/test/resources/serializer-snapshot-v" + version, new String[0]);
    }

    private static <T> AvroSerializerSnapshot<T> roundTrip(TypeSerializerSnapshot<T> original) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(1024);
        original.writeSnapshot((DataOutputView)out);
        AvroSerializerSnapshot restored = new AvroSerializerSnapshot();
        DataInputDeserializer in = new DataInputDeserializer(out.wrapAsByteBuffer());
        restored.readSnapshot(restored.getCurrentVersion(), (DataInputView)in, original.getClass().getClassLoader());
        return restored;
    }

    private static <T> ByteBuffer serialize(TypeSerializer<T> serializer, T record) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(1024);
        serializer.serialize(record, (DataOutputView)out);
        return out.wrapAsByteBuffer();
    }

    private static <T> T deserialize(TypeSerializer<T> serializer, ByteBuffer serializedRecord) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serializedRecord);
        return (T)serializer.deserialize((DataInputView)in);
    }

    private static class Pojo {
        private String foo;

        private Pojo() {
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }
}

