/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.formats.avro.AvroRowDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowSerializationSchema;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class AvroRowDeSerializationSchemaTest {
    AvroRowDeSerializationSchemaTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSpecificSerializeDeserializeFromSchema(boolean legacyTimestampMapping) throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        if (legacyTimestampMapping) {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        } else {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testGenericSerializeDeserialize(boolean legacyTimestampMapping) throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        if (legacyTimestampMapping) {
            byte[] bytes = serializationSchema.serialize((Row)testData.f1);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        } else {
            byte[] bytes = serializationSchema.serialize((Row)testData.f1, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSpecificSerializeFromClassSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        if (legacyTimestampMapping) {
            serializationSchema.serialize((Row)testData.f2);
            serializationSchema.serialize((Row)testData.f2);
            byte[] bytes = serializationSchema.serialize((Row)testData.f2);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        } else {
            serializationSchema.serialize((Row)testData.f2, false);
            serializationSchema.serialize((Row)testData.f2, false);
            byte[] bytes = serializationSchema.serialize((Row)testData.f2, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSpecificSerializeFromSchemaSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        if (legacyTimestampMapping) {
            serializationSchema.serialize((Row)testData.f2);
            serializationSchema.serialize((Row)testData.f2);
            byte[] bytes = serializationSchema.serialize((Row)testData.f2);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        } else {
            serializationSchema.serialize((Row)testData.f2, false);
            serializationSchema.serialize((Row)testData.f2, false);
            byte[] bytes = serializationSchema.serialize((Row)testData.f2, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testGenericSerializeSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        if (legacyTimestampMapping) {
            serializationSchema.serialize((Row)testData.f1);
            serializationSchema.serialize((Row)testData.f1);
            byte[] bytes = serializationSchema.serialize((Row)testData.f1);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        } else {
            serializationSchema.serialize((Row)testData.f1, false);
            serializationSchema.serialize((Row)testData.f1, false);
            byte[] bytes = serializationSchema.serialize((Row)testData.f1, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSpecificDeserializeFromClassSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        if (legacyTimestampMapping) {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2);
            deserializationSchema.deserialize(bytes);
            deserializationSchema.deserialize(bytes);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        } else {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2, false);
            deserializationSchema.deserialize(bytes, false);
            deserializationSchema.deserialize(bytes, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSpecificDeserializeFromSchemaSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        if (legacyTimestampMapping) {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2);
            deserializationSchema.deserialize(bytes);
            deserializationSchema.deserialize(bytes);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        } else {
            byte[] bytes = serializationSchema.serialize((Row)testData.f2, false);
            deserializationSchema.deserialize(bytes, false);
            deserializationSchema.deserialize(bytes, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f2);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testGenericDeserializeSeveralTimes(boolean legacyTimestampMapping) throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        if (legacyTimestampMapping) {
            byte[] bytes = serializationSchema.serialize((Row)testData.f1);
            deserializationSchema.deserialize(bytes);
            deserializationSchema.deserialize(bytes);
            Row actual = deserializationSchema.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        } else {
            byte[] bytes = serializationSchema.serialize((Row)testData.f1, false);
            deserializationSchema.deserialize(bytes, false);
            deserializationSchema.deserialize(bytes, false);
            Row actual = deserializationSchema.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo(testData.f1);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSerializability(boolean legacyTimestampMapping) throws Exception {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema classSer = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema classDeser = new AvroRowDeserializationSchema((Class)testData.f0);
        this.testSerializability(classSer, classDeser, (Row)testData.f2, legacyTimestampMapping);
        AvroRowSerializationSchema schemaSer = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema schemaDeser = new AvroRowDeserializationSchema(schemaString);
        this.testSerializability(schemaSer, schemaDeser, (Row)testData.f2, legacyTimestampMapping);
    }

    void testTimestampSerializeDeserializeLegacyMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serializationSchema.serialize((Row)testData.f3)).isInstanceOf(RuntimeException.class)).hasMessage("Unsupported local timestamp type.");
        byte[] bytes = serializationSchema.serialize((Row)testData.f3, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> deserializationSchema.deserialize(bytes)).isInstanceOf(RuntimeException.class)).hasMessage("Unsupported local timestamp type.");
    }

    @Test
    void testTimestampSpecificSerializeDeserializeNewMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        byte[] bytes = serializationSchema.serialize((Row)testData.f3, false);
        Row actual = deserializationSchema.deserialize(bytes, false);
        Assertions.assertThat((Object)actual).isEqualTo(testData.f3);
    }

    @Test
    void testTimestampGenericGenericSerializeDeserializeNewMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        String schemaString = ((GenericRecord)testData.f2).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        byte[] bytes = serializationSchema.serialize((Row)testData.f3);
        Row actual = deserializationSchema.deserialize(bytes);
        Assertions.assertThat((Object)actual).isEqualTo(testData.f3);
    }

    @Test
    void testTimestampClassSerializeDeserializeNewMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f3);
        Row actual = deserializationSchema.deserialize(bytes);
        Assertions.assertThat((Object)actual).isEqualTo(testData.f3);
    }

    private void testSerializability(AvroRowSerializationSchema ser, AvroRowDeserializationSchema deser, Row data, boolean legacyTimestampMapping) throws Exception {
        byte[] serBytes = InstantiationUtil.serializeObject((Object)ser);
        byte[] deserBytes = InstantiationUtil.serializeObject((Object)deser);
        AvroRowSerializationSchema serCopy = (AvroRowSerializationSchema)InstantiationUtil.deserializeObject((byte[])serBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        AvroRowDeserializationSchema deserCopy = (AvroRowDeserializationSchema)InstantiationUtil.deserializeObject((byte[])deserBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        if (legacyTimestampMapping) {
            byte[] bytes = serCopy.serialize(data);
            deserCopy.deserialize(bytes);
            deserCopy.deserialize(bytes);
            Row actual = deserCopy.deserialize(bytes);
            Assertions.assertThat((Object)actual).isEqualTo((Object)data);
        } else {
            byte[] bytes = serCopy.serialize(data, false);
            deserCopy.deserialize(bytes, false);
            deserCopy.deserialize(bytes, false);
            Row actual = deserCopy.deserialize(bytes, false);
            Assertions.assertThat((Object)actual).isEqualTo((Object)data);
        }
    }
}

