/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AvroRecordInputFormatTest {
    public File testFile;
    static final String TEST_NAME = "Alyssa";
    static final String TEST_ARRAY_STRING_1 = "ELEMENT 1";
    static final String TEST_ARRAY_STRING_2 = "ELEMENT 2";
    static final boolean TEST_ARRAY_BOOLEAN_1 = true;
    static final boolean TEST_ARRAY_BOOLEAN_2 = false;
    static final Colors TEST_ENUM_COLOR = Colors.GREEN;
    static final String TEST_MAP_KEY1 = "KEY 1";
    static final long TEST_MAP_VALUE1 = 8546456L;
    static final String TEST_MAP_KEY2 = "KEY 2";
    static final long TEST_MAP_VALUE2 = 17554L;
    static final int TEST_NUM = 239;
    static final String TEST_STREET = "Baker Street";
    static final String TEST_CITY = "London";
    static final String TEST_STATE = "London";
    static final String TEST_ZIP = "NW1 6XE";
    private final Schema userSchema = new User().getSchema();

    public static void writeTestFile(File testFile) throws IOException {
        ArrayList<CharSequence> stringArray = new ArrayList<CharSequence>();
        stringArray.add(TEST_ARRAY_STRING_1);
        stringArray.add(TEST_ARRAY_STRING_2);
        ArrayList<Boolean> booleanArray = new ArrayList<Boolean>();
        booleanArray.add(true);
        booleanArray.add(false);
        HashMap<CharSequence, Long> longMap = new HashMap<CharSequence, Long>();
        longMap.put(TEST_MAP_KEY1, 8546456L);
        longMap.put(TEST_MAP_KEY2, 17554L);
        Address addr = new Address();
        addr.setNum(239);
        addr.setStreet(TEST_STREET);
        addr.setCity("London");
        addr.setState("London");
        addr.setZip(TEST_ZIP);
        User user1 = new User();
        user1.setName(TEST_NAME);
        user1.setFavoriteNumber(256);
        user1.setTypeDoubleTest(123.45);
        user1.setTypeBoolTest(true);
        user1.setTypeArrayString(stringArray);
        user1.setTypeArrayBoolean(booleanArray);
        user1.setTypeEnum(TEST_ENUM_COLOR);
        user1.setTypeMap(longMap);
        user1.setTypeNested(addr);
        user1.setTypeBytes(ByteBuffer.allocate(10));
        user1.setTypeDate(LocalDate.parse("2014-03-01"));
        user1.setTypeTimeMillis(LocalTime.parse("12:12:12"));
        user1.setTypeTimeMicros(LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS));
        user1.setTypeTimestampMillis(Instant.parse("2014-03-01T12:12:12.321Z"));
        user1.setTypeTimestampMicros(Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS));
        user1.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        user1.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        User user2 = User.newBuilder().setName("Charlie").setFavoriteColor("blue").setFavoriteNumber(null).setTypeBoolTest(false).setTypeDoubleTest(1.337).setTypeNullTest(null).setTypeLongTest(1337L).setTypeArrayString(new ArrayList<CharSequence>()).setTypeArrayBoolean(new ArrayList<Boolean>()).setTypeNullableArray(null).setTypeEnum(Colors.RED).setTypeMap(new HashMap<CharSequence, Long>()).setTypeFixed(null).setTypeUnion(null).setTypeNested(Address.newBuilder().setNum(239).setStreet(TEST_STREET).setCity("London").setState("London").setZip(TEST_ZIP).build()).setTypeBytes(ByteBuffer.allocate(10)).setTypeDate(LocalDate.parse("2014-03-01")).setTypeTimeMillis(LocalTime.parse("12:12:12")).setTypeTimeMicros(LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS)).setTypeTimestampMillis(Instant.parse("2014-03-01T12:12:12.321Z")).setTypeTimestampMicros(Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS)).setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).build();
        SpecificDatumWriter userDatumWriter = new SpecificDatumWriter(User.class);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)userDatumWriter);
        dataFileWriter.create(user1.getSchema(), testFile);
        dataFileWriter.append((Object)user1);
        dataFileWriter.append((Object)user2);
        dataFileWriter.close();
    }

    @BeforeEach
    public void createFiles() throws IOException {
        this.testFile = File.createTempFile("AvroInputFormatTest", null);
        AvroRecordInputFormatTest.writeTestFile(this.testFile);
    }

    @Test
    void testDeserialization() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.configure(parameters);
        Object[] splits = format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(1);
        format.open((FileInputSplit)splits[0]);
        User u = (User)((Object)format.nextRecord(null));
        Assertions.assertThat((Comparable)((Object)u)).isNotNull();
        String name = u.getName().toString();
        Assertions.assertThat((String)name).isEqualTo(TEST_NAME);
        List<CharSequence> sl = u.getTypeArrayString();
        Assertions.assertThat((String)sl.get(0).toString()).isEqualTo(TEST_ARRAY_STRING_1);
        Assertions.assertThat((String)sl.get(1).toString()).isEqualTo(TEST_ARRAY_STRING_2);
        List<Boolean> bl = u.getTypeArrayBoolean();
        Assertions.assertThat(bl).containsExactly((Object[])new Boolean[]{true, false});
        Colors enumValue = u.getTypeEnum();
        Assertions.assertThat((Comparable)((Object)enumValue)).isEqualTo((Object)TEST_ENUM_COLOR);
        Map<CharSequence, Long> lm = u.getTypeMap();
        Assertions.assertThat(lm).containsOnly(new Map.Entry[]{MapEntry.entry((Object)new Utf8(TEST_MAP_KEY1), (Object)8546456L), MapEntry.entry((Object)new Utf8(TEST_MAP_KEY2), (Object)17554L)});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)format.reachedEnd()).as("expecting second element", new Object[0])).isFalse();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Comparable)format.nextRecord((Object)u))).as("expecting second element", new Object[0])).isNotNull();
        Assertions.assertThat((Comparable)((Comparable)format.nextRecord((Object)u))).isNull();
        Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        format.close();
    }

    @Test
    void testDeserializationReuseAvroRecordFalse() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.setReuseAvroValue(false);
        format.configure(parameters);
        Object[] splits = format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(1);
        format.open((FileInputSplit)splits[0]);
        User u = (User)((Object)format.nextRecord(null));
        Assertions.assertThat((Comparable)((Object)u)).isNotNull();
        String name = u.getName().toString();
        Assertions.assertThat((String)name).isEqualTo(TEST_NAME);
        List<CharSequence> sl = u.getTypeArrayString();
        Assertions.assertThat((String)sl.get(0).toString()).isEqualTo(TEST_ARRAY_STRING_1);
        Assertions.assertThat((String)sl.get(1).toString()).isEqualTo(TEST_ARRAY_STRING_2);
        List<Boolean> bl = u.getTypeArrayBoolean();
        Assertions.assertThat(bl).containsExactly((Object[])new Boolean[]{true, false});
        Colors enumValue = u.getTypeEnum();
        Assertions.assertThat((Comparable)((Object)enumValue)).isEqualTo((Object)TEST_ENUM_COLOR);
        Map<CharSequence, Long> lm = u.getTypeMap();
        Assertions.assertThat(lm).containsOnly(new Map.Entry[]{MapEntry.entry((Object)new Utf8(TEST_MAP_KEY1), (Object)8546456L), MapEntry.entry((Object)new Utf8(TEST_MAP_KEY2), (Object)17554L)});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)format.reachedEnd()).as("expecting second element", new Object[0])).isFalse();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Comparable)format.nextRecord((Object)u))).as("expecting second element", new Object[0])).isNotNull();
        Assertions.assertThat((Comparable)((Comparable)format.nextRecord((Object)u))).isNull();
        Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        format.close();
    }

    @Test
    void testDeserializeToGenericType() throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader(this.userSchema);
        try (FileReader dataFileReader = DataFileReader.openReader((File)this.testFile, (DatumReader)datumReader);){
            GenericData.Record newRec;
            GenericData.Record rec = new GenericData.Record(this.userSchema);
            dataFileReader.next((Object)rec);
            Assertions.assertThat((Comparable)rec).isNotNull();
            Assertions.assertThat((String)rec.get("name").toString()).isEqualTo(TEST_NAME);
            Assertions.assertThat((String)rec.get("type_enum").toString()).isEqualTo(TEST_ENUM_COLOR.toString());
            Assertions.assertThat((Object)rec.get("type_long_test")).isNull();
            TypeInformation te = TypeExtractor.createTypeInfo(GenericData.Record.class);
            ExecutionConfig ec = new ExecutionConfig();
            Assertions.assertThat((Object)te).isExactlyInstanceOf(GenericTypeInfo.class);
            Serializers.recursivelyRegisterType((Class)te.getTypeClass(), (SerializerConfig)ec.getSerializerConfig(), new HashSet());
            TypeSerializer tser = te.createSerializer(ec.getSerializerConfig());
            ((MapAssert)Assertions.assertThat((Map)ec.getSerializerConfig().getDefaultKryoSerializerClasses()).hasSize(1)).containsEntry(Schema.class, AvroKryoSerializerUtils.AvroSchemaSerializer.class);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)out);){
                tser.serialize((Object)rec, (DataOutputView)outView);
            }
            try (DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                newRec = (GenericData.Record)tser.deserialize((DataInputView)inView);
            }
            Assertions.assertThat((Comparable)newRec).isNotNull();
            Assertions.assertThat((String)newRec.get("name").toString()).isEqualTo(TEST_NAME);
            Assertions.assertThat((String)newRec.get("type_enum").toString()).isEqualTo(TEST_ENUM_COLOR.toString());
            Assertions.assertThat((Object)newRec.get("type_long_test")).isNull();
        }
    }

    @Test
    void testDeserializeToSpecificType() throws IOException {
        SpecificDatumReader datumReader = new SpecificDatumReader(this.userSchema);
        try (FileReader dataFileReader = DataFileReader.openReader((File)this.testFile, (DatumReader)datumReader);){
            User newRec;
            User rec = (User)((Object)dataFileReader.next());
            Assertions.assertThat((Comparable)((Object)rec)).isNotNull();
            Assertions.assertThat((String)rec.get("name").toString()).isEqualTo(TEST_NAME);
            Assertions.assertThat((String)rec.get("type_enum").toString()).isEqualTo(TEST_ENUM_COLOR.toString());
            ExecutionConfig ec = new ExecutionConfig();
            TypeInformation te = TypeExtractor.createTypeInfo(User.class);
            Assertions.assertThat((Object)te).isExactlyInstanceOf(AvroTypeInfo.class);
            TypeSerializer tser = te.createSerializer(ec.getSerializerConfig());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)out);){
                tser.serialize((Object)rec, (DataOutputView)outView);
            }
            try (DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                newRec = (User)((Object)tser.deserialize((DataInputView)inView));
            }
            Assertions.assertThat((Comparable)((Object)newRec)).isNotNull();
            Assertions.assertThat((String)newRec.get("name").toString()).isEqualTo(TEST_NAME);
            Assertions.assertThat((String)newRec.get("type_enum").toString()).isEqualTo(TEST_ENUM_COLOR.toString());
        }
    }

    @Test
    void testDeserializationGenericRecord() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), GenericRecord.class);
        this.doTestDeserializationGenericRecord((AvroInputFormat<GenericRecord>)format, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestDeserializationGenericRecord(AvroInputFormat<GenericRecord> format, Configuration parameters) throws IOException {
        try {
            format.configure(parameters);
            Object[] splits = format.createInputSplits(1);
            Assertions.assertThat((Object[])splits).hasSize(1);
            format.open((FileInputSplit)splits[0]);
            GenericRecord u = (GenericRecord)format.nextRecord(null);
            Assertions.assertThat((Object)u).isNotNull();
            Assertions.assertThat((Object)u.getSchema()).isEqualTo((Object)this.userSchema);
            String name = u.get("name").toString();
            Assertions.assertThat((String)name).isEqualTo(TEST_NAME);
            List sl = (List)u.get("type_array_string");
            Assertions.assertThat((String)((CharSequence)sl.get(0)).toString()).isEqualTo(TEST_ARRAY_STRING_1);
            Assertions.assertThat((String)((CharSequence)sl.get(1)).toString()).isEqualTo(TEST_ARRAY_STRING_2);
            List bl = (List)u.get("type_array_boolean");
            Assertions.assertThat((List)bl).containsExactly((Object[])new Boolean[]{true, false});
            GenericData.EnumSymbol enumValue = (GenericData.EnumSymbol)u.get("type_enum");
            Assertions.assertThat((Comparable)enumValue).isEqualTo((Object)TEST_ENUM_COLOR);
            Map lm = (Map)u.get("type_map");
            Assertions.assertThat((Map)lm).containsOnly(new Map.Entry[]{MapEntry.entry((Object)new Utf8(TEST_MAP_KEY1), (Object)8546456L), MapEntry.entry((Object)new Utf8(TEST_MAP_KEY2), (Object)17554L)});
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)format.reachedEnd()).as("expecting second element", new Object[0])).isFalse();
            ((ObjectAssert)Assertions.assertThat((Object)format.nextRecord((Object)u)).as("expecting second element", new Object[0])).isNotNull();
            Assertions.assertThat((Object)format.nextRecord((Object)u)).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        finally {
            format.close();
        }
    }

    @Test
    void testDeserializationGenericRecordReuseAvroValueFalse() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), GenericRecord.class);
        format.configure(parameters);
        format.setReuseAvroValue(false);
        this.doTestDeserializationGenericRecord((AvroInputFormat<GenericRecord>)format, parameters);
    }

    @AfterEach
    public void deleteFiles() {
        this.testFile.delete();
    }
}

