/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AbstractAvroBulkFormat;
import org.apache.flink.formats.avro.AvroBulkFormatTestUtils;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AvroBulkFormatTest {
    private static final List<RowData> TEST_DATA = Arrays.asList(GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"AvroBulk"), StringData.fromString((String)"FormatTest")}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"Apache"), StringData.fromString((String)"Flink")}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"\u6c38\u548c\u4e5d\u5e74\uff0c\u5c81\u5728\u7678\u4e11\uff0c\u66ae\u6625\u4e4b\u521d\uff0c\u4f1a\u4e8e\u4f1a\u7a3d\u5c71\u9634\u4e4b\u5170\u4ead\uff0c\u4fee\u798a\u4e8b\u4e5f\u3002\u7fa4\u8d24\u6bd5\u81f3\uff0c\u5c11\u957f\u54b8\u96c6\u3002\u6b64\u5730\u6709\u5d07\u5c71\u5cfb\u5cad\uff0c\u8302\u6797\u4fee\u7af9\uff0c\u53c8\u6709\u6e05\u6d41\u6fc0\u6e4d\uff0c\u6620\u5e26\u5de6\u53f3\u3002\u5f15\u4ee5\u4e3a\u6d41\u89de\u66f2\u6c34\uff0c\u5217\u5750\u5176\u6b21\u3002\u867d\u65e0\u4e1d\u7af9\u7ba1\u5f26\u4e4b\u76db\uff0c\u4e00\u89de\u4e00\u548f\uff0c\u4ea6\u8db3\u4ee5\u7545\u53d9\u5e7d\u60c5\u3002"), StringData.fromString((String)"")}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"File"), StringData.fromString((String)"Format")}), GenericRowData.of((Object[])new Object[]{null, StringData.fromString((String)"This is a string with English, \u4e2d\u6587 and even \ud83c\udf4e\ud83c\udf4c\ud83c\udf51\ud83e\udd5d\ud83c\udf4d\ud83e\udd6d\ud83c\udf50")}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"block with"), StringData.fromString((String)"only one record")}));
    private static final List<Long> BLOCK_STARTS = Arrays.asList(232L, 593L, 705L);
    private File tmpFile;

    AvroBulkFormatTest() {
    }

    @BeforeEach
    public void before() throws IOException {
        this.tmpFile = Files.createTempFile("avro-bulk-format-test", ".avro", new FileAttribute[0]).toFile();
        this.tmpFile.createNewFile();
        FileOutputStream out = new FileOutputStream(this.tmpFile);
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)AvroBulkFormatTestUtils.ROW_TYPE);
        RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)AvroBulkFormatTestUtils.ROW_TYPE);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, (OutputStream)out);
        long syncBlock1 = dataFileWriter.sync();
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(0))));
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(1))));
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(2))));
        long syncBlock2 = dataFileWriter.sync();
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(3))));
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(4))));
        long syncBlock3 = dataFileWriter.sync();
        dataFileWriter.append((Object)((GenericRecord)converter.convert(schema, (Object)TEST_DATA.get(5))));
        long syncEnd = dataFileWriter.sync();
        dataFileWriter.close();
        Assertions.assertThat(BLOCK_STARTS).isEqualTo(Arrays.asList(syncBlock1, syncBlock2, syncBlock3));
        Assertions.assertThat((File)this.tmpFile).hasSize(syncEnd);
    }

    @AfterEach
    public void after() throws IOException {
        FileUtils.deleteFileOrDirectory((File)this.tmpFile);
    }

    @Test
    void testReadWholeFileWithOneSplit() throws IOException {
        AvroBulkFormatTestUtils.TestingAvroBulkFormat bulkFormat = new AvroBulkFormatTestUtils.TestingAvroBulkFormat();
        this.assertSplit(bulkFormat, Collections.singletonList(new SplitInfo(0L, this.tmpFile.length(), Arrays.asList(new BatchInfo(0, 3), new BatchInfo(3, 5), new BatchInfo(5, 6)))));
    }

    @Test
    void testReadWholeFileWithMultipleSplits() throws IOException {
        AvroBulkFormatTestUtils.TestingAvroBulkFormat bulkFormat = new AvroBulkFormatTestUtils.TestingAvroBulkFormat();
        long splitLength = this.tmpFile.length() / 3L;
        this.assertSplit(bulkFormat, Arrays.asList(new SplitInfo(0L, splitLength, Collections.singletonList(new BatchInfo(0, 3))), new SplitInfo(splitLength, splitLength * 2L, Collections.emptyList()), new SplitInfo(splitLength * 2L, this.tmpFile.length(), Arrays.asList(new BatchInfo(3, 5), new BatchInfo(5, 6)))));
    }

    @Test
    void testSplitsAtCriticalLocations() throws IOException {
        AvroBulkFormatTestUtils.TestingAvroBulkFormat bulkFormat = new AvroBulkFormatTestUtils.TestingAvroBulkFormat();
        this.assertSplit(bulkFormat, Arrays.asList(new SplitInfo(BLOCK_STARTS.get(0) - 16L, BLOCK_STARTS.get(1) - 16L, Collections.singletonList(new BatchInfo(0, 3))), new SplitInfo(BLOCK_STARTS.get(1) - 16L, BLOCK_STARTS.get(2) - 16L + 1L, Arrays.asList(new BatchInfo(3, 5), new BatchInfo(5, 6)))));
    }

    @Test
    void testRestoreReader() throws IOException {
        AvroBulkFormatTestUtils.TestingAvroBulkFormat bulkFormat = new AvroBulkFormatTestUtils.TestingAvroBulkFormat();
        long splitLength = this.tmpFile.length() / 3L;
        String splitId = UUID.randomUUID().toString();
        FileSourceSplit split = new FileSourceSplit(splitId, new Path(this.tmpFile.toString()), splitLength * 2L, this.tmpFile.length());
        AbstractAvroBulkFormat.AvroReader reader = bulkFormat.createReader(new Configuration(), split);
        long offset1 = this.assertBatch((BulkFormat.Reader<RowData>)reader, new BatchInfo(3, 5));
        this.assertBatch((BulkFormat.Reader<RowData>)reader, new BatchInfo(5, 6));
        Assertions.assertThat((Object)reader.readBatch()).isNull();
        reader.close();
        split = new FileSourceSplit(splitId, new Path(this.tmpFile.toString()), splitLength * 2L, this.tmpFile.length(), StringUtils.EMPTY_STRING_ARRAY, new CheckpointedPosition(offset1, 1L));
        reader = bulkFormat.restoreReader(new Configuration(), split);
        long offset2 = this.assertBatch((BulkFormat.Reader<RowData>)reader, new BatchInfo(3, 5), 1);
        this.assertBatch((BulkFormat.Reader<RowData>)reader, new BatchInfo(5, 6));
        Assertions.assertThat((Object)reader.readBatch()).isNull();
        reader.close();
        Assertions.assertThat((long)offset2).isEqualTo(offset1);
    }

    private void assertSplit(AvroBulkFormatTestUtils.TestingAvroBulkFormat bulkFormat, List<SplitInfo> splitInfos) throws IOException {
        for (SplitInfo splitInfo : splitInfos) {
            FileSourceSplit split = new FileSourceSplit(UUID.randomUUID().toString(), new Path(this.tmpFile.toString()), splitInfo.start, splitInfo.end - splitInfo.start);
            AbstractAvroBulkFormat.AvroReader reader = bulkFormat.createReader(new Configuration(), split);
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (BatchInfo batch : splitInfo.batches) {
                offsets.add(this.assertBatch((BulkFormat.Reader<RowData>)reader, batch));
            }
            Assertions.assertThat((Object)reader.readBatch()).isNull();
            for (int j = 1; j < offsets.size(); ++j) {
                Assertions.assertThat(((Long)offsets.get(j - 1) < (Long)offsets.get(j) ? 1 : 0) != 0).isTrue();
            }
            reader.close();
        }
    }

    private long assertBatch(BulkFormat.Reader<RowData> reader, BatchInfo batchInfo) throws IOException {
        return this.assertBatch(reader, batchInfo, 0);
    }

    private long assertBatch(BulkFormat.Reader<RowData> reader, BatchInfo batchInfo, int initialSkipCount) throws IOException {
        long ret = -1L;
        int skipCount = initialSkipCount;
        BulkFormat.RecordIterator iterator = reader.readBatch();
        RecordAndPosition recordAndPos = iterator.next();
        while (recordAndPos != null) {
            if (ret == -1L) {
                ret = recordAndPos.getOffset();
            }
            Assertions.assertThat((Object)recordAndPos.getRecord()).isEqualTo((Object)TEST_DATA.get(batchInfo.start + skipCount));
            Assertions.assertThat((long)recordAndPos.getOffset()).isEqualTo(ret);
            Assertions.assertThat((long)recordAndPos.getRecordSkipCount()).isEqualTo((long)(++skipCount));
            recordAndPos = iterator.next();
        }
        Assertions.assertThat((int)skipCount).isEqualTo(batchInfo.end - batchInfo.start);
        iterator.releaseBatch();
        return ret;
    }

    private static class BatchInfo {
        private final int start;
        private final int end;

        private BatchInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }

    private static class SplitInfo {
        private final long start;
        private final long end;
        private final List<BatchInfo> batches;

        private SplitInfo(long start, long end, List<BatchInfo> batches) {
            this.start = start;
            this.end = end;
            this.batches = batches;
        }
    }
}

