/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import java.util.Arrays;
import org.apache.flink.architecture.common.Conditions;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.JavaFieldPredicates;
import org.apache.flink.architecture.common.Predicates;
import org.apache.flink.connector.testframe.environment.MiniClusterTestEnvironment;
import org.apache.flink.connector.testframe.junit.annotations.TestEnv;
import org.apache.flink.runtime.testutils.InternalMiniClusterExtension;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ITCaseRules {
    @ArchTest
    public static final ArchRule INTEGRATION_TEST_ENDING_WITH_ITCASE = (ArchRule)FreezingArchRule.freeze((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().areAssignableTo(AbstractTestBase.class)).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().haveSimpleNameEndingWith("ITCase")).allowEmptyShould(true).as("Tests inheriting from AbstractTestBase should have name ending with ITCase");
    @ArchTest
    public static final ArchRule ITCASE_USE_MINICLUSTER = (ArchRule)FreezingArchRule.freeze((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().haveSimpleNameEndingWith("ITCase")).and().areTopLevelClasses()).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should(Conditions.fulfill((DescribedPredicate)ITCaseRules.miniClusterExtensionRule().or(ITCaseRules.miniClusterWithClientResourceClassRule()).or(ITCaseRules.miniClusterWithClientResourceRule())))).allowEmptyShould(true).as("ITCASE tests should use a MiniCluster resource or extension");

    private static DescribedPredicate<JavaClass> miniClusterWithClientResourceClassRule() {
        return Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.arePublicStaticFinalOfTypeWithAnnotation(MiniClusterWithClientResource.class, ClassRule.class));
    }

    private static DescribedPredicate<JavaClass> miniClusterWithClientResourceRule() {
        return Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.arePublicFinalOfTypeWithAnnotation(MiniClusterWithClientResource.class, Rule.class));
    }

    private static DescribedPredicate<JavaClass> inFlinkRuntimePackages() {
        return JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.runtime.*");
    }

    private static DescribedPredicate<JavaClass> outsideFlinkRuntimePackages() {
        return JavaClass.Predicates.resideOutsideOfPackage((String)"org.apache.flink.runtime.*");
    }

    private static DescribedPredicate<JavaClass> miniClusterExtensionRule() {
        return Predicates.exactlyOneOf((DescribedPredicate[])new DescribedPredicate[]{ITCaseRules.inFlinkRuntimePackages().and(Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.areStaticFinalOfTypeWithAnnotation(InternalMiniClusterExtension.class, RegisterExtension.class))), ITCaseRules.outsideFlinkRuntimePackages().and(Predicates.containAnyFieldsInClassHierarchyThat((DescribedPredicate)Predicates.areStaticFinalOfTypeWithAnnotation(MiniClusterExtension.class, RegisterExtension.class).or(Predicates.areFieldOfType(MiniClusterTestEnvironment.class, (JavaModifier[])new JavaModifier[0]).and(JavaFieldPredicates.annotatedWith(TestEnv.class))))), ITCaseRules.inFlinkRuntimePackages().and(ITCaseRules.isAnnotatedWithExtendWithUsingExtension(InternalMiniClusterExtension.class)), ITCaseRules.outsideFlinkRuntimePackages().and(ITCaseRules.isAnnotatedWithExtendWithUsingExtension(MiniClusterExtension.class))});
    }

    private static DescribedPredicate<JavaClass> isAnnotatedWithExtendWithUsingExtension(Class<? extends Extension> extensionClass) {
        return DescribedPredicate.describe((String)("is annotated with @ExtendWith with class " + extensionClass.getSimpleName()), clazz -> clazz.isAnnotatedWith(ExtendWith.class) && Arrays.asList(((ExtendWith)clazz.getAnnotationOfType(ExtendWith.class)).value()).contains(extensionClass));
    }
}

