/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.architecture.common.Conditions;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.Predicates;
import org.apache.flink.architecture.common.SourcePredicates;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class TableApiRules {
    private static final Pattern TABLE_API_MODULES = Pattern.compile(".*/flink-table-(api-(bridge-base|java(|-bridge))|common)/.*");
    public static final String CONFIG_OPTIONS_FQ_NAME = "org.apache.flink.configuration.ConfigOption";
    @ArchTest
    public static final ArchRule CONFIG_OPTIONS_IN_OPTIONS_CLASSES = ((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that(Predicates.arePublicStaticOfType((String)"org.apache.flink.configuration.ConfigOption")).and().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.table..")))).should().beDeclaredInClassesThat().haveSimpleNameEndingWith("Options")).orShould().beDeclaredIn(FactoryUtil.class);
    @ArchTest
    public static final ArchRule TABLE_FACTORIES_CONTAIN_NO_CONFIG_OPTIONS = (ArchRule)((GivenFieldsConjunction)ArchRuleDefinition.noFields().that(Predicates.arePublicStaticOfType((String)"org.apache.flink.configuration.ConfigOption")).and().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.table..")))).should().beDeclaredInClassesThat().implement(DynamicTableFactory.class);
    @ArchTest
    public static final ArchRule CONNECTOR_OPTIONS_PACKAGE = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().haveSimpleNameEndingWith("ConnectorOptions")).or().haveSimpleNameEndingWith("FormatOptions")).and().haveSimpleNameNotContaining("Json")).should().resideInAPackage("org.apache.flink..table").andShould(Conditions.fulfill((DescribedPredicate)Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{PublicEvolving.class, Public.class}))).as("Options for connectors and formats should reside in a consistent package and be public API.")));
    @ArchTest
    public static final ArchRule ALL_CLASSES_IN_TABLE_API_SHOULD_HAVE_VISIBILITY_ANNOTATIONS = (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat(TableApiRules.resideInPublicTableApiModules()).and().resideInAPackage("org.apache.flink.table..")).and().arePublic()).should(Conditions.fulfill((DescribedPredicate)Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Internal.class, Experimental.class, PublicEvolving.class, Public.class, Deprecated.class}))).as("All public classes residing in the flink-table-api-java, flink-table-api-java-bridge, flink-table-common or flink-table-api-bridge-base modules should be explicitly marked with a visibility annotation");

    private static DescribedPredicate<JavaClass> resideInPublicTableApiModules() {
        return new DescribedPredicate<JavaClass>("Reside in public TableApi modules", new Object[0]){

            public boolean test(JavaClass input) {
                Optional sourceOptional = input.getSource();
                if (sourceOptional.isPresent()) {
                    Source source = (Source)sourceOptional.get();
                    return Location.of((URI)source.getUri()).matches(TABLE_API_MODULES);
                }
                return false;
            }
        };
    }
}

