/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.architecture.common.Conditions;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.Predicates;
import org.apache.flink.architecture.common.SourcePredicates;

public class ApiAnnotationRules {
    @ArchTest
    public static final ArchRule ANNOTATED_APIS = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().resideInAPackage("org.apache.flink..api..")).and().resideOutsideOfPackage("..internal..")).and().arePublic()).should(Conditions.fulfill((DescribedPredicate)Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Internal.class, Experimental.class, PublicEvolving.class, Public.class, Deprecated.class}))).as("Classes in API packages should have at least one API visibility annotation.")));
    @ArchTest
    public static final ArchRule PUBLIC_API_METHODS_USE_ONLY_PUBLIC_API_TYPES = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(Public.class)).or().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(CanBeAnnotated.Predicates.annotatedWith(Public.class)))).and().arePublic()).and().areNotAnnotatedWith(PublicEvolving.class)).and().areNotAnnotatedWith(Internal.class)).and().areNotAnnotatedWith(Deprecated.class)).and().areNotAnnotatedWith(Experimental.class)).should(Conditions.haveLeafTypes((DescribedPredicate)JavaClass.Predicates.resideOutsideOfPackage((String)"org.apache.flink..").or(ApiAnnotationRules.resideInShadedPackage()).or(Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Public.class, Deprecated.class})))).as("Return and argument types of methods annotated with @Public must be annotated with @Public.")));
    @ArchTest
    public static final ArchRule PUBLIC_EVOLVING_API_METHODS_USE_ONLY_PUBLIC_EVOLVING_API_TYPES = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(PublicEvolving.class)).or().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{PublicEvolving.class})))).and().arePublic()).and().areNotAnnotatedWith(Internal.class)).and().areNotAnnotatedWith(Deprecated.class)).and().areNotAnnotatedWith(Experimental.class)).should(Conditions.haveLeafTypes((DescribedPredicate)JavaClass.Predicates.resideOutsideOfPackage((String)"org.apache.flink..").or(ApiAnnotationRules.resideInShadedPackage()).or(Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Public.class, PublicEvolving.class, Deprecated.class})))).as("Return and argument types of methods annotated with @PublicEvolving must be annotated with @Public(Evolving).")));
    @ArchTest
    public static final ArchRule NO_CALLS_TO_VISIBLE_FOR_TESTING_METHODS = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenClassesConjunction)GivenJavaClasses.noJavaClassesThat().resideInAPackage("org.apache.flink..")).should().callMethodWhere((DescribedPredicate)new DescribedPredicate<JavaMethodCall>("the target is annotated @" + VisibleForTesting.class.getSimpleName(), new Object[0]){

        public boolean test(JavaMethodCall call) {
            JavaClass targetOwner = call.getTargetOwner();
            JavaClass originOwner = call.getOriginOwner();
            if (call.getOrigin().isAnnotatedWith(VisibleForTesting.class)) {
                return false;
            }
            if (originOwner.equals(targetOwner)) {
                return false;
            }
            if (originOwner.getEnclosingClass().map(targetOwner::equals).orElse(false).booleanValue()) {
                return false;
            }
            if (targetOwner.getEnclosingClass().map(originOwner::equals).orElse(false).booleanValue()) {
                return false;
            }
            return ((AccessTarget.MethodCallTarget)call.getTarget()).isAnnotatedWith(VisibleForTesting.class);
        }
    }).as("Production code must not call methods annotated with @VisibleForTesting")));

    private static DescribedPredicate<JavaClass> resideInShadedPackage() {
        return JavaClass.Predicates.resideInAnyPackage((String[])new String[]{"..shaded.."});
    }
}

