/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.Source;

public class SourcePredicates {
    public static DescribedPredicate<JavaClass> areJavaClasses() {
        return new DescribedPredicate<JavaClass>("are Java classes", new Object[0]){

            public boolean apply(JavaClass clazz) {
                return SourcePredicates.isJavaClass(clazz);
            }
        };
    }

    static boolean isJavaClass(JavaClass clazz) {
        if (!clazz.getSource().isPresent()) {
            return false;
        }
        Source source = (Source)clazz.getSource().get();
        if (!source.getFileName().isPresent()) {
            return false;
        }
        return ((String)source.getFileName().get()).contains(".java");
    }

    private SourcePredicates() {
    }
}

