/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.architecture.common.SourcePredicates;

public class Conditions {
    public static <T extends HasName> ArchCondition<T> fulfill(final DescribedPredicate<T> predicate) {
        return new ArchCondition<T>(predicate.getDescription(), new Object[0]){

            public void check(T item, ConditionEvents events) {
                if (!predicate.apply(item)) {
                    String message = String.format("%s does not satisfy: %s", item.getName(), predicate.getDescription());
                    events.add(SimpleConditionEvent.violated(item, (String)message));
                }
            }
        };
    }

    public static ArchCondition<JavaMethod> haveLeafTypes(DescribedPredicate<JavaClass> typePredicate) {
        return Conditions.haveLeafReturnTypes(typePredicate).and(Conditions.haveLeafArgumentTypes(typePredicate)).and(Conditions.haveLeafExceptionTypes(typePredicate));
    }

    public static ArchCondition<JavaMethod> haveLeafReturnTypes(final DescribedPredicate<JavaClass> typePredicate) {
        return new ArchCondition<JavaMethod>("have leaf return types" + typePredicate.getDescription(), new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                for (JavaClass leafType : Conditions.getLeafTypes(method.getReturnType())) {
                    if (!SourcePredicates.isJavaClass(leafType) || typePredicate.apply((Object)leafType)) continue;
                    String message = String.format("%s: Returned leaf type %s does not satisfy: %s", method.getFullName(), leafType.getName(), typePredicate.getDescription());
                    events.add(SimpleConditionEvent.violated((Object)method, (String)message));
                }
            }
        };
    }

    public static ArchCondition<JavaMethod> haveLeafArgumentTypes(final DescribedPredicate<JavaClass> typePredicate) {
        return new ArchCondition<JavaMethod>("have leaf argument types" + typePredicate.getDescription(), new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                List leafArgumentTypes = method.getParameterTypes().stream().flatMap(argumentType -> Conditions.getLeafTypes(argumentType).stream()).collect(Collectors.toList());
                for (JavaClass leafType : leafArgumentTypes) {
                    if (!SourcePredicates.isJavaClass(leafType) || typePredicate.apply((Object)leafType)) continue;
                    String message = String.format("%s: Argument leaf type %s does not satisfy: %s", method.getFullName(), leafType.getName(), typePredicate.getDescription());
                    events.add(SimpleConditionEvent.violated((Object)method, (String)message));
                }
            }
        };
    }

    public static ArchCondition<JavaMethod> haveLeafExceptionTypes(final DescribedPredicate<JavaClass> typePredicate) {
        return new ArchCondition<JavaMethod>("have leaf exception types" + typePredicate.getDescription(), new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                List leafArgumentTypes = method.getExceptionTypes().stream().flatMap(argumentType -> Conditions.getLeafTypes((JavaType)argumentType).stream()).collect(Collectors.toList());
                for (JavaClass leafType : leafArgumentTypes) {
                    if (!SourcePredicates.isJavaClass(leafType) || typePredicate.apply((Object)leafType)) continue;
                    String message = String.format("%s: Exception leaf type %s does not satisfy: %s", method.getFullName(), leafType.getName(), typePredicate.getDescription());
                    events.add(SimpleConditionEvent.violated((Object)method, (String)message));
                }
            }
        };
    }

    private static List<JavaClass> getLeafTypes(JavaType type) {
        JavaClass baseComponentType = type.toErasure().getBaseComponentType();
        if (type instanceof JavaParameterizedType) {
            JavaParameterizedType parameterizedType = (JavaParameterizedType)type;
            return Stream.concat(Stream.of(baseComponentType), parameterizedType.getActualTypeArguments().stream()).flatMap(types -> Conditions.getLeafTypes(types).stream()).filter(SourcePredicates::isJavaClass).collect(Collectors.toList());
        }
        return Collections.singletonList(baseComponentType);
    }

    private Conditions() {
    }
}

