/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.classpath;

import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.classpath.ClasspathTransporter;

@Named(value="classpath")
@Component(role=TransporterFactory.class, hint="classpath")
public final class ClasspathTransporterFactory
implements TransporterFactory,
Service {
    public static final String CONFIG_PROP_CLASS_LOADER = "aether.connector.classpath.loader";
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public ClasspathTransporterFactory() {
    }

    @Inject
    ClasspathTransporterFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public ClasspathTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, ClasspathTransporter.class);
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public float getPriority() {
        return this.priority;
    }

    public ClasspathTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new ClasspathTransporter(session, repository, this.logger);
    }
}

