/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.classpath;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.classpath.ResourceNotFoundException;
import org.eclipse.aether.util.ConfigUtils;

final class ClasspathTransporter
extends AbstractTransporter {
    private final String resourceBase;
    private final ClassLoader classLoader;

    public ClasspathTransporter(RepositorySystemSession session, RemoteRepository repository, Logger logger) throws NoTransporterException {
        String base;
        if (!"classpath".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        try {
            URI uri = new URI(repository.getUrl());
            String ssp = uri.getSchemeSpecificPart();
            if (ssp.startsWith("/")) {
                base = uri.getPath();
                if (base == null) {
                    base = "";
                } else if (base.startsWith("/")) {
                    base = base.substring(1);
                }
            } else {
                base = ssp;
            }
            if (base.length() > 0 && !base.endsWith("/")) {
                base = base + '/';
            }
        }
        catch (URISyntaxException e) {
            throw new NoTransporterException(repository, (Throwable)e);
        }
        this.resourceBase = base;
        Object cl = ConfigUtils.getObject(session, null, "aether.connector.classpath.loader");
        this.classLoader = cl instanceof ClassLoader ? (ClassLoader)cl : Thread.currentThread().getContextClassLoader();
    }

    private URL getResource(TransportTask task) throws Exception {
        String resource = this.resourceBase + task.getLocation().getPath();
        URL url = this.classLoader.getResource(resource);
        if (url == null) {
            throw new ResourceNotFoundException("Could not locate " + resource);
        }
        return url;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        this.getResource(task);
    }

    protected void implGet(GetTask task) throws Exception {
        URL url = this.getResource(task);
        URLConnection conn = url.openConnection();
        this.utilGet(task, conn.getInputStream(), true, conn.getContentLength(), false);
    }

    protected void implPut(PutTask task) throws Exception {
        throw new UnsupportedOperationException("Uploading to a classpath: repository is not supported");
    }

    protected void implClose() {
    }
}

