/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=Installer.class)
public class DefaultInstaller
implements Installer,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement(role=MetadataGeneratorFactory.class)
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    @Requirement
    private SyncContextFactory syncContextFactory;

    public DefaultInstaller() {
    }

    @Inject
    DefaultInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultInstaller setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultInstaller addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("metadata generator factory has not been specified");
        }
        this.metadataFactories.add(factory);
        return this;
    }

    public DefaultInstaller setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    DefaultInstaller setMetadataFactories(List<MetadataGeneratorFactory> metadataFactories) {
        return this.setMetadataGeneratorFactories(metadataFactories);
    }

    public DefaultInstaller setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        SyncContext syncContext = this.syncContextFactory.newInstance(session, false);
        try {
            InstallResult installResult = this.install(syncContext, session, request);
            return installResult;
        }
        finally {
            syncContext.close();
        }
    }

    private InstallResult install(SyncContext syncContext, RepositorySystemSession session, InstallRequest request) throws InstallationException {
        InstallResult result = new InstallResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
        IdentityHashMap processedMetadata = new IdentityHashMap();
        List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
        syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
        for (Metadata metadata : metadatas) {
            this.install(session, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)artifacts.get(i);
            for (MetadataGenerator metadataGenerator : generators) {
                artifact = metadataGenerator.transformArtifact(artifact);
            }
            artifacts.set(i, artifact);
            this.install(session, trace, artifact);
            result.addArtifact(artifact);
        }
        metadatas = Utils.finishMetadata(generators, artifacts);
        syncContext.acquire(null, metadatas);
        for (Metadata metadata : metadatas) {
            this.install(session, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        for (Metadata metadata : request.getMetadata()) {
            if (processedMetadata.containsKey(metadata)) continue;
            this.install(session, trace, metadata);
            result.addMetadata(metadata);
        }
        return result;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, InstallRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory : factories.getEnabled()) {
            MetadataGenerator generator = factory.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File srcFile = artifact.getFile();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(artifact));
        this.artifactInstalling(session, trace, artifact, dstFile);
        Exception exception = null;
        try {
            boolean copy;
            if (dstFile.equals(srcFile)) {
                throw new IllegalArgumentException("Cannot install " + dstFile + " to same path");
            }
            boolean bl = copy = "pom".equals(artifact.getExtension()) || srcFile.lastModified() != dstFile.lastModified() || srcFile.length() != dstFile.length() || !srcFile.exists();
            if (copy) {
                this.fileProcessor.copy(srcFile, dstFile);
                dstFile.setLastModified(srcFile.lastModified());
            } else {
                this.logger.debug("Skipped re-installing " + srcFile + " to " + dstFile + ", seems unchanged");
            }
            lrm.add(session, new LocalArtifactRegistration(artifact));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install artifact " + artifact + ": " + e.getMessage(), e);
        }
        finally {
            this.artifactInstalled(session, trace, artifact, dstFile, exception);
        }
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Metadata metadata) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalMetadata(metadata));
        this.metadataInstalling(session, trace, metadata, dstFile);
        Exception exception = null;
        try {
            if (metadata instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            } else {
                if (dstFile.equals(metadata.getFile())) {
                    throw new IllegalArgumentException("Cannot install " + dstFile + " to same path");
                }
                this.fileProcessor.copy(metadata.getFile(), dstFile);
            }
            lrm.add(session, new LocalMetadataRegistration(metadata));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install metadata " + metadata + ": " + e.getMessage(), e);
        }
        finally {
            this.metadataInstalled(session, trace, metadata, dstFile, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session, RequestTrace trace, Artifact artifact, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactInstalled(RepositorySystemSession session, RequestTrace trace, Artifact artifact, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalling(RepositorySystemSession session, RequestTrace trace, Metadata metadata, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalled(RepositorySystemSession session, RequestTrace trace, Metadata metadata, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

