/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.retrievers.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressBar.class);
    protected long total;

    public ProgressBar(long total) {
        this.total = total;
        this.drawOutput(0L);
    }

    public void updateProgress(long current) {
        this.drawOutput(current);
    }

    protected void drawOutput(long current) {
        int transferredPercent = (int)Math.round((double)current / (double)this.total * 100.0);
        int segmentsTransferred = transferredPercent / 2;
        int segmentsRest = 50 - segmentsTransferred;
        LOG.info("\r" + String.format(" %3d", transferredPercent) + "% [" + StringUtils.repeat("=", segmentsTransferred) + (segmentsRest > 0 ? ">" + StringUtils.repeat(" ", segmentsRest - 1) : "") + "] ");
    }
}

