/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.retrievers.download;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.flex.utilities.converter.api.ProxySettings;
import org.apache.flex.utilities.converter.retrievers.BaseRetriever;
import org.apache.flex.utilities.converter.retrievers.download.SystemIdHelper;
import org.apache.flex.utilities.converter.retrievers.exceptions.RetrieverException;
import org.apache.flex.utilities.converter.retrievers.types.PlatformType;
import org.apache.flex.utilities.converter.retrievers.types.SdkType;
import org.apache.flex.utilities.converter.retrievers.utils.ProgressBar;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DownloadRetriever
extends BaseRetriever {
    public static final String FLEX_INSTALLER_CONFIG_URL = "http://flex.apache.org/installer/sdk-installer-config-4.0.xml";
    public static final long MEGABYTE = 0x100000L;
    private static final Logger LOG = LoggerFactory.getLogger(DownloadRetriever.class);

    protected String getFlexInstallerConfigUrl() {
        return FLEX_INSTALLER_CONFIG_URL;
    }

    public File retrieve(SdkType type) throws RetrieverException {
        return this.retrieve(type, null, null);
    }

    public File retrieve(SdkType type, String version) throws RetrieverException {
        return this.retrieve(type, version, null);
    }

    @Override
    public File retrieve(SdkType type, String version, PlatformType platformType) throws RetrieverException {
        try {
            if (type.equals((Object)SdkType.FLASH) || type.equals((Object)SdkType.AIR) || type.equals((Object)SdkType.FONTKIT)) {
                this.confirmLicenseAcceptance(type);
            }
            if (type.equals((Object)SdkType.FONTKIT)) {
                File tmpTargetFile = File.createTempFile(UUID.randomUUID().toString(), "");
                String tempSuffix = tmpTargetFile.getName().substring(tmpTargetFile.getName().lastIndexOf("-"));
                if (!tmpTargetFile.delete()) {
                    throw new IOException("Could not delete temp file: " + tmpTargetFile.getAbsolutePath());
                }
                File targetRootDir = new File(tmpTargetFile.getParentFile(), type.toString() + tempSuffix);
                File targetDir = new File(targetRootDir, "/lib/external/optional");
                if (!targetDir.mkdirs()) {
                    throw new IOException("Could not create temp directory: " + targetDir.getAbsolutePath());
                }
                URI afeUri = new URI("https://sourceforge.net/adobe/flexsdk/code/HEAD/tree/trunk/lib/afe.jar?format=raw");
                File afeFile = new File(targetDir, "afe.jar");
                this.performSafeDownload(afeUri, afeFile);
                URI aglj40Uri = new URI("https://sourceforge.net/adobe/flexsdk/code/HEAD/tree/trunk/lib/aglj40.jar?format=raw");
                File aglj40File = new File(targetDir, "aglj40.jar");
                this.performSafeDownload(aglj40Uri, aglj40File);
                URI rideauUri = new URI("https://sourceforge.net/adobe/flexsdk/code/HEAD/tree/trunk/lib/rideau.jar?format=raw");
                File rideauFile = new File(targetDir, "rideau.jar");
                this.performSafeDownload(rideauUri, rideauFile);
                URI flexFontkitUri = new URI("https://sourceforge.net/adobe/flexsdk/code/HEAD/tree/trunk/lib/flex-fontkit.jar?format=raw");
                File flexFontkitFile = new File(targetDir, "flex-fontkit.jar");
                this.performSafeDownload(flexFontkitUri, flexFontkitFile);
                return targetRootDir;
            }
            URL sourceUrl = new URL(this.getBinaryUrl(type, version, platformType));
            File targetFile = File.createTempFile(type.toString() + "-" + version + (platformType != null ? "-" + (Object)((Object)platformType) : "") + "-", sourceUrl.getFile().substring(sourceUrl.getFile().lastIndexOf(".")));
            this.performSafeDownload(new URI(this.getBinaryUrl(type, version, platformType)), targetFile);
            if (type.equals((Object)SdkType.FLASH)) {
                File targetDirectory = new File(targetFile.getParent(), targetFile.getName().substring(0, targetFile.getName().lastIndexOf(".") - 1));
                File libDestFile = new File(targetDirectory, "frameworks/libs/player/" + version + "/playerglobal.swc");
                if (!libDestFile.getParentFile().exists() && !libDestFile.getParentFile().mkdirs()) {
                    throw new RetrieverException("Error creating directory " + libDestFile.getParent());
                }
                FileUtils.moveFile(targetFile, libDestFile);
                return targetDirectory;
            }
            LOG.info("Extracting archive to temp directory.");
            File targetDirectory = new File(targetFile.getParent(), targetFile.getName().substring(0, targetFile.getName().lastIndexOf(".") - 1));
            if (type.equals((Object)SdkType.SWFOBJECT)) {
                this.unpack(targetFile, new File(targetDirectory, "templates"));
            } else {
                this.unpack(targetFile, targetDirectory);
            }
            LOG.info("");
            LOG.info("Finished extracting.");
            LOG.info("===========================================================");
            if (type.equals((Object)SdkType.SWFOBJECT)) {
                File delFile = new File(targetDirectory, "templates/swfobject/index_dynamic.html");
                FileUtils.deleteQuietly(delFile);
                delFile = new File(targetDirectory, "templates/swfobject/index.html");
                FileUtils.deleteQuietly(delFile);
                delFile = new File(targetDirectory, "templates/swfobject/test.swf");
                FileUtils.deleteQuietly(delFile);
                delFile = new File(targetDirectory, "templates/swfobject/src");
                FileUtils.deleteDirectory(delFile);
            }
            return targetDirectory;
        }
        catch (MalformedURLException e) {
            throw new RetrieverException("Error downloading archive.", e);
        }
        catch (FileNotFoundException e) {
            throw new RetrieverException("Error downloading archive.", e);
        }
        catch (SSLHandshakeException e) {
            throw new RetrieverException("Error downloading archive. There were problems in the SSL handshake. In case of Sourceforge this is probably related to Sourceforge using strong encryption for SSL and the default Oracle JDK not supporting this. If you are able to do so please install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 8 available from http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html", e);
        }
        catch (IOException e) {
            throw new RetrieverException("Error downloading archive.", e);
        }
        catch (URISyntaxException e) {
            throw new RetrieverException("Error downloading archive.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFastDownload(URL sourceUrl, File targetFile) throws IOException {
        URLConnection connection;
        ProxySettings proxySettings = ProxySettings.getProxySettings();
        if (proxySettings != null) {
            InetSocketAddress socketAddress = new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort());
            Proxy proxy = new Proxy(Proxy.Type.valueOf(proxySettings.getProtocol().toUpperCase()), socketAddress);
            connection = sourceUrl.openConnection(proxy);
        } else {
            connection = sourceUrl.openConnection();
        }
        ReadableByteChannel rbc = null;
        FileOutputStream fos = null;
        try {
            rbc = Channels.newChannel(connection.getInputStream());
            fos = new FileOutputStream(targetFile);
            long expectedSize = connection.getContentLength();
            long transferedSize = 0L;
            LOG.info("===========================================================");
            LOG.info("Downloading " + sourceUrl.toString());
            if (expectedSize > 1038336L) {
                LOG.info("Expected size: " + expectedSize / 1024L / 1024L + "MB");
            } else {
                LOG.info("Expected size: " + expectedSize / 1024L + "KB");
            }
            ProgressBar progressBar = new ProgressBar(expectedSize);
            while (transferedSize < expectedSize) {
                transferedSize += fos.getChannel().transferFrom(rbc, transferedSize, 0x100000L);
                progressBar.updateProgress(transferedSize);
            }
        }
        finally {
            if (rbc != null) {
                try {
                    rbc.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        LOG.info("");
        LOG.info("Finished downloading.");
        LOG.info("===========================================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSafeDownload(URI sourceUri, File targetFile) throws IOException {
        RequestConfig config;
        ProxySettings proxySettings = ProxySettings.getProxySettings();
        if (proxySettings != null) {
            HttpHost proxy = new HttpHost(proxySettings.getHost(), proxySettings.getPort());
            config = RequestConfig.custom().setProxy(proxy).build();
        } else {
            config = RequestConfig.DEFAULT;
        }
        Closeable httpclient = null;
        try {
            HttpGet httpget = new HttpGet(sourceUri);
            httpget.setConfig(config);
            httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = ((CloseableHttpClient)httpclient).execute(httpget);
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            int statusCode = response.getStatusLine().getStatusCode();
            LOG.info(String.format("statusCode: %d", statusCode));
            LOG.info(String.format("reasonPhrase: %s", reasonPhrase));
            HttpEntity entity = response.getEntity();
            InputStream content = entity.getContent();
            ReadableByteChannel rbc = null;
            FileOutputStream fos = null;
            try {
                rbc = Channels.newChannel(content);
                fos = new FileOutputStream(targetFile);
                long expectedSize = entity.getContentLength();
                LOG.info("===========================================================");
                LOG.info("Downloading " + sourceUri.toString());
                if (expectedSize <= 0L) {
                    try {
                        LOG.info("Unknown size.");
                        IOUtils.copy(content, (OutputStream)fos);
                    }
                    finally {
                        content.close();
                    }
                } else {
                    long currentSize;
                    if (expectedSize > 1038336L) {
                        LOG.info("Expected size: " + expectedSize / 1024L / 1024L + "MB");
                    } else {
                        LOG.info("Expected size: " + expectedSize / 1024L + "KB");
                    }
                    ProgressBar progressBar = new ProgressBar(expectedSize);
                    long transferredSize = 0L;
                    while (transferredSize < expectedSize && (currentSize = fos.getChannel().transferFrom(rbc, transferredSize, 0x100000L)) >= 0x100000L) {
                        progressBar.updateProgress(transferredSize += currentSize);
                    }
                    fos.close();
                    LOG.info("");
                }
                LOG.info("Finished downloading.");
                LOG.info("===========================================================");
            }
            finally {
                if (rbc != null) {
                    try {
                        rbc.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getBinaryUrl(SdkType sdkType, String version, PlatformType platformType) throws RetrieverException {
        try {
            URLConnection connection;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            URL configUrl = new URL(this.getFlexInstallerConfigUrl());
            ProxySettings proxySettings = ProxySettings.getProxySettings();
            if (proxySettings != null) {
                InetSocketAddress socketAddress = new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort());
                Proxy proxy = new Proxy(Proxy.Type.valueOf(proxySettings.getProtocol().toUpperCase()), socketAddress);
                connection = configUrl.openConnection(proxy);
                LOG.info("Using proxy: " + proxySettings.getHost());
            } else {
                connection = configUrl.openConnection();
            }
            Document doc = builder.parse(connection.getInputStream());
            String expression = this.getUrlXpath(sdkType, version, platformType);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Element artifactElement = (Element)xPath.evaluate(expression, doc.getDocumentElement(), XPathConstants.NODE);
            if (artifactElement == null) {
                throw new RetrieverException("Could not find " + sdkType.toString() + " SDK with version " + version);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (sdkType == SdkType.FLEX || sdkType == SdkType.SWFOBJECT) {
                String path = artifactElement.getAttribute("path");
                String file = artifactElement.getAttribute("file");
                if (!path.startsWith("http://")) {
                    stringBuilder.append("http://archive.apache.org/dist/");
                }
                stringBuilder.append(path);
                if (!path.endsWith("/")) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(file);
                if (sdkType == SdkType.FLEX) {
                    stringBuilder.append(".zip");
                }
            } else {
                NodeList pathElements = artifactElement.getElementsByTagName("path");
                NodeList fileElements = artifactElement.getElementsByTagName("file");
                if (pathElements.getLength() != 1 && fileElements.getLength() != 1) {
                    throw new RetrieverException("Invalid document structure.");
                }
                String path = pathElements.item(0).getTextContent();
                stringBuilder.append(path);
                if (!path.endsWith("/")) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(fileElements.item(0).getTextContent());
            }
            return stringBuilder.toString();
        }
        catch (ParserConfigurationException e) {
            throw new RetrieverException("Error parsing 'sdk-installer-config-4.0.xml'", e);
        }
        catch (SAXException e) {
            throw new RetrieverException("Error parsing 'sdk-installer-config-4.0.xml'", e);
        }
        catch (XPathExpressionException e) {
            throw new RetrieverException("Error parsing 'sdk-installer-config-4.0.xml'", e);
        }
        catch (IOException e) {
            throw new RetrieverException("Error parsing 'sdk-installer-config-4.0.xml'", e);
        }
    }

    protected String getUrlXpath(SdkType sdkType, String version, PlatformType platformType) throws RetrieverException {
        StringBuilder stringBuilder = new StringBuilder();
        switch (sdkType) {
            case FLEX: {
                stringBuilder.append("//*[@id='").append(version).append("']");
                break;
            }
            case AIR: {
                stringBuilder.append("//*[@id='air.sdk.version.");
                if (platformType == null) {
                    throw new RetrieverException("You need to specify the platformType parameter for AIR SDKs.");
                }
                switch (platformType) {
                    case WINDOWS: {
                        stringBuilder.append("windows");
                        break;
                    }
                    case MAC: {
                        stringBuilder.append("mac");
                        break;
                    }
                    case LINUX: {
                        stringBuilder.append("linux");
                    }
                }
                stringBuilder.append(".").append(version).append("']");
                break;
            }
            case FLASH: {
                stringBuilder.append("//*[@id='flash.sdk.version.").append(version).append("']");
                break;
            }
            case FONTKIT: {
                stringBuilder.append("//fontswf");
                break;
            }
            case SWFOBJECT: {
                stringBuilder.append("//swfobject");
            }
        }
        return stringBuilder.toString();
    }

    protected void confirmLicenseAcceptance(SdkType type) throws RetrieverException {
        String question;
        String systemId;
        Properties questionProps = new Properties();
        try {
            questionProps.load(DownloadRetriever.class.getClassLoader().getResourceAsStream("message.properties"));
        }
        catch (IOException e) {
            throw new RetrieverException("Error reading message.properties file", e);
        }
        String property = "com.adobe.systemIdsForWhichTheTermsOfTheAdobeLicenseAgreementAreAccepted";
        String acceptedSystemIds = System.getProperty(property);
        if (acceptedSystemIds == null) {
            acceptedSystemIds = System.getenv("com.adobe.systemIdsForWhichTheTermsOfTheAdobeLicenseAgreementAreAccepted");
        }
        if (acceptedSystemIds != null && (systemId = SystemIdHelper.getSystemId()) != null) {
            for (String acceptedSystemId : acceptedSystemIds.split(",")) {
                if (!systemId.equals(acceptedSystemId)) continue;
                System.out.println(questionProps.getProperty("ACCEPTED_USING_SYSTEM_ID"));
                return;
            }
        }
        if (type.equals((Object)SdkType.FLASH)) {
            question = questionProps.getProperty("ASK_ADOBE_FLASH_PLAYER_GLOBAL_SWC");
        } else if (type.equals((Object)SdkType.AIR)) {
            question = questionProps.getProperty("ASK_ADOBE_AIR_SDK");
        } else if (type.equals((Object)SdkType.FONTKIT)) {
            question = questionProps.getProperty("ASK_ADOBE_FONTKIT");
        } else {
            throw new RetrieverException("Unknown SdkType");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String answer;
            do {
                System.out.println(MessageFormat.format(questionProps.getProperty("SYSTEM_ID"), SystemIdHelper.getSystemId()));
                System.out.println(question);
                System.out.println(MessageFormat.format(questionProps.getProperty("ACCEPT_USING_SYSTEM_ID"), property, SystemIdHelper.getSystemId()));
                System.out.print(questionProps.getProperty("DO_YOU_ACCEPT_QUESTION") + " ");
                answer = reader.readLine();
                if (!"YES".equalsIgnoreCase(answer) && !"Y".equalsIgnoreCase(answer)) continue;
                return;
            } while (!"NO".equalsIgnoreCase(answer) && !"N".equalsIgnoreCase(answer));
            System.out.println("You have to accept the license agreement in order to proceed.");
            throw new RetrieverException("You have to accept the license agreement in order to proceed.");
        }
        catch (IOException e) {
            throw new RetrieverException("Couldn't read from Stdin.");
        }
    }

    public Map<DefaultArtifactVersion, Collection<PlatformType>> getAvailableVersions(SdkType type) {
        HashMap<DefaultArtifactVersion, Collection<PlatformType>> result = new HashMap<DefaultArtifactVersion, Collection<PlatformType>>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.getFlexInstallerConfigUrl());
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodes = null;
            switch (type) {
                case FLEX: {
                    String expression = "/config/products/ApacheFlexSDK/versions/*";
                    nodes = (NodeList)xPath.evaluate(expression, doc.getDocumentElement(), XPathConstants.NODESET);
                    break;
                }
                case FLASH: {
                    String expression = "/config/flashsdk/versions/*";
                    nodes = (NodeList)xPath.evaluate(expression, doc.getDocumentElement(), XPathConstants.NODESET);
                    break;
                }
                case AIR: {
                    String expression = "/config/airsdk/*/versions/*";
                    nodes = (NodeList)xPath.evaluate(expression, doc.getDocumentElement(), XPathConstants.NODESET);
                }
            }
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    DefaultArtifactVersion version = new DefaultArtifactVersion(element.getAttribute("version"));
                    if (type == SdkType.AIR) {
                        PlatformType platformType = PlatformType.valueOf(element.getParentNode().getParentNode().getNodeName().toUpperCase());
                        if (!result.containsKey(version)) {
                            result.put(version, new ArrayList());
                        }
                        ((Collection)result.get(version)).add(platformType);
                        continue;
                    }
                    result.put(version, null);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }
}

