/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.retrievers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.flex.utilities.converter.retrievers.Retriever;
import org.apache.flex.utilities.converter.retrievers.exceptions.RetrieverException;
import org.apache.flex.utilities.converter.retrievers.utils.ProgressBar;

public abstract class BaseRetriever
implements Retriever {
    public static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int BUFFER_MAX = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpack(File inputArchive, File targetDirectory) throws RetrieverException {
        if (!targetDirectory.mkdirs()) {
            throw new RetrieverException("Unable to create extraction directory " + targetDirectory.getAbsolutePath());
        }
        InputStream archiveInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            ArchiveEntry entry;
            fileInputStream = new FileInputStream(inputArchive);
            CountingInputStream inputStream = new CountingInputStream(fileInputStream);
            long inputFileSize = inputArchive.length();
            archiveInputStream = inputArchive.getName().endsWith(".tbz2") ? new TarArchiveInputStream(new BZip2CompressorInputStream(inputStream)) : new ArchiveStreamFactory().createArchiveInputStream(new BufferedInputStream(inputStream));
            ProgressBar progressBar = new ProgressBar(inputFileSize);
            while ((entry = ((ArchiveInputStream)archiveInputStream).getNextEntry()) != null) {
                File outputFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (!outputFile.exists() && !outputFile.mkdirs()) {
                        throw new RetrieverException("Could not create output directory " + outputFile.getAbsolutePath());
                    }
                } else {
                    byte[] data = new byte[0x100000];
                    try (FileOutputStream fos = null;){
                        fos = new FileOutputStream(outputFile);
                        BufferedOutputStream dest = null;
                        try {
                            int count;
                            dest = new BufferedOutputStream(fos, 0x100000);
                            while ((count = archiveInputStream.read(data, 0, 0x100000)) != -1) {
                                dest.write(data, 0, count);
                                progressBar.updateProgress(inputStream.getBytesRead());
                            }
                        }
                        finally {
                            if (dest != null) {
                                dest.flush();
                                dest.close();
                            }
                        }
                    }
                }
                progressBar.updateProgress(inputStream.getBytesRead());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
        finally {
            if (archiveInputStream != null) {
                try {
                    archiveInputStream.close();
                }
                catch (IOException e) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

