/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.deployer.aether;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(AetherDeployer.class);
    private File directory;
    private String url;
    private String username;
    private String password;

    public AetherDeployer(File directory, String url, String username, String password) {
        this.directory = directory;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public AetherDeployer(String[] parameters) {
        this.directory = new File(parameters[0]);
        this.url = parameters[1];
        if (parameters.length > 2) {
            this.username = parameters[2];
            this.password = parameters[3];
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 4) {
            AetherDeployer.printUsage();
            System.exit(0);
        }
        AetherDeployer deployer = new AetherDeployer(args);
        deployer.deploy();
    }

    private static void printUsage() {
        LOG.error("\nUsage: java -cp flex-sdk-converter-1.0.jar SDKInVMDeployer \"directory\" \"url\" [\"username\", \"password\"]\nThe SDKDeployer needs at least 2 ordered parameters separated by spaces:\n\t1- directory: The path to the directory containing the artifacts that should be deployed.\b\t2- url: URL where the artifacts will be deployed.\nIf the targeted repository requires authentication two more parameters have to be provided:\n\t3- username: The username used to authenticate on the target repository.\n\t4- password: The password used to authenticate on the target repository.");
    }

    public void deploy() {
        try {
            DefaultServiceLocator locator = new DefaultServiceLocator();
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(VersionResolver.class, DefaultVersionResolver.class);
            locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
            locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
            locator.addService(DependencyCollector.class, DefaultDependencyCollector.class);
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterProvider.class, DefaultTransporterProvider.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            RepositorySystem repositorySystem = locator.getService(RepositorySystem.class);
            if (repositorySystem == null) {
                LOG.error("Couldn't initialize local maven repository system.");
                System.exit(0);
            } else {
                DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
                LocalRepository localRepo = new LocalRepository(this.directory);
                RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder("repo", "default", this.url);
                if (this.username != null && this.password != null) {
                    Authentication authentication = new AuthenticationBuilder().addUsername(this.username).addPassword(this.password).build();
                    repoBuilder.setAuthentication(authentication);
                }
                RemoteRepository remoteRepository = repoBuilder.build();
                session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager(session, localRepo));
                File rootDir = this.directory;
                this.processDir(rootDir, repositorySystem, session, remoteRepository);
            }
        }
        catch (Throwable e) {
            LOG.error("Error deploying artifacts in directory: " + this.directory.getAbsolutePath(), e);
        }
    }

    private void processDir(File curDir, RepositorySystem repositorySystem, RepositorySystemSession session, RemoteRepository remoteRepository) throws IOException, XmlPullParserException, InstallationException, DeploymentException {
        File[] dirs;
        File[] poms = curDir.listFiles(new PomFilter());
        if (poms != null) {
            for (File pom : poms) {
                this.processArtifact(pom, repositorySystem, session, remoteRepository);
            }
        }
        if ((dirs = curDir.listFiles(new DirFilter())) != null) {
            for (File dir : dirs) {
                this.processDir(dir, repositorySystem, session, remoteRepository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArtifact(File pomFile, RepositorySystem repositorySystem, RepositorySystemSession session, RemoteRepository remoteRepository) throws IOException, XmlPullParserException, InstallationException, DeploymentException {
        try (FileReader reader = new FileReader(pomFile);){
            File artifactDirectory = pomFile.getParentFile();
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            Model model = xpp3Reader.read(reader);
            DeployRequest artifactInstallRequest = new DeployRequest();
            artifactInstallRequest.setRepository(remoteRepository);
            Artifact pomArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), "pom", model.getVersion());
            pomArtifact = pomArtifact.setFile(pomFile);
            artifactInstallRequest.addArtifact(pomArtifact);
            String artifactBaseName = model.getArtifactId() + "-" + model.getVersion();
            File[] artifactFiles = artifactDirectory.listFiles(new ArtifactFilter());
            for (File artifactFile : artifactFiles) {
                String fileName = artifactFile.getName();
                if (!fileName.startsWith(artifactBaseName)) continue;
                String classifier = fileName.charAt(artifactBaseName.length()) == '-' ? fileName.substring(artifactBaseName.length() + 1, fileName.indexOf(".", artifactBaseName.length())) : "";
                String extension = fileName.substring(artifactBaseName.length() + 1 + (classifier.length() > 0 ? classifier.length() + 1 : 0));
                Artifact fileArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), classifier, extension, model.getVersion());
                fileArtifact = fileArtifact.setFile(artifactFile);
                artifactInstallRequest.addArtifact(fileArtifact);
            }
            LOG.info("Installing Artifact: " + pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion());
            for (Artifact artifact : artifactInstallRequest.getArtifacts()) {
                LOG.info(" - File with extension " + artifact.getExtension() + (artifact.getClassifier().length() > 0 ? " and classifier " + artifact.getClassifier() : ""));
            }
            repositorySystem.deploy(session, artifactInstallRequest);
        }
    }

    private class ArtifactFilter
    implements FileFilter {
        private ArtifactFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().endsWith(".pom") && !pathname.isDirectory();
        }
    }

    private class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private class PomFilter
    implements FileFilter {
        private PomFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".pom");
        }
    }
}

