/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.flex.utilities.converter.air.AirConverter;
import org.apache.flex.utilities.converter.api.ProxySettings;
import org.apache.flex.utilities.converter.deployer.aether.AetherDeployer;
import org.apache.flex.utilities.converter.flash.FlashConverter;
import org.apache.flex.utilities.converter.flex.FlexConverter;
import org.apache.flex.utilities.converter.fontkit.FontkitConverter;
import org.apache.flex.utilities.converter.retrievers.download.DownloadRetriever;
import org.apache.flex.utilities.converter.retrievers.types.PlatformType;
import org.apache.flex.utilities.converter.retrievers.types.SdkType;
import org.apache.flex.utilities.converter.wrapper.WrapperConverter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class SdkConverterCLI {
    public static final String COMMAND_HELP = "help";
    public static final String COMMAND_LIST = "list";
    public static final String COMMAND_DOWNLOAD = "download";
    public static final String COMMAND_CONVERT = "convert";
    public static final String COMMAND_DEPLOY = "deploy";
    public static final String OPTION_FLEX_VERSION = "flexVersion";
    public static final String OPTION_FLASH_VERSIONS = "flashVersions";
    public static final String OPTION_AIT_VERSION = "airVersion";
    public static final String OPTION_FONTKIT = "fontkit";
    public static final String OPTION_PLATFORMS = "platforms";
    public static final String OPTION_FDK_DIR = "fdkDir";
    public static final String OPTION_MAVEN_DIR = "mavenDir";
    public static final String OPTION_REPO_URL = "repoUrl";
    public static final String OPTION_REPO_USERNAME = "repoUsername";
    public static final String OPTION_REPO_PASSWORD = "repoPassword";
    public static final String OPTION_PROXY_PROTOCOL = "proxyProtocol";
    public static final String OPTION_PROXY_HOST = "proxyHost";
    public static final String OPTION_PROXY_PORT = "proxyPort";
    public static final String OPTION_PROXY_NON_PROXY_HOST = "proxyNonProxyHost";
    public static final String OPTION_PROXY_USERNAME = "proxyUsername";
    public static final String OPTION_PROXY_PASSWORD = "proxyPassword";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName("version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and Only valid for download) Version of the FDK which should be downloaded.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_FLEX_VERSION));
        OptionBuilder.withArgName("version(s)");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withDescription("(Optional and Only valid for download) Version(s) of the Adobe Flash SDK which should be downloaded. Multiple versions can be separated by \",\".");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_FLASH_VERSIONS));
        OptionBuilder.withArgName("version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and Only valid for download) Version of the Adobe Air SDK which should be downloaded.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_AIT_VERSION));
        OptionBuilder.withDescription("(Optional and Only valid for download) If provided, the Converter will also download the Fontkit libraries needed for font encoding.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_FONTKIT));
        OptionBuilder.withArgName("platform(s)");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withDescription("(Optional and Only valid for download) Platform the artifacts should be downloaded for. If omitted the platform this process is run on will be used. Valid options are: \"WINDOWS\", \"MAC\" and \"LNX\". Multiple versions can be separated by \",\".");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PLATFORMS));
        OptionBuilder.withArgName("dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional) Directory that the FDK will be located in. If omitted, a temporary directory will be used.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_FDK_DIR));
        OptionBuilder.withArgName("dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional) Directory that the mavenized artifacts will be located in. If omitted, a temporary directory will be used.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_MAVEN_DIR));
        OptionBuilder.withArgName("url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid for deploy) Url of the remote Maven repository that the generated Maven artifacts should be deployed to.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_REPO_URL));
        OptionBuilder.withArgName("username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid for deploy) Username used to authenticate on the remote Maven repository that the generated Maven artifacts should be deployed to.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_REPO_USERNAME));
        OptionBuilder.withArgName("password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid for deploy) Password used to authenticate on the remote Maven repository that the generated Maven artifacts should be deployed to.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_REPO_PASSWORD));
        OptionBuilder.withArgName("protocol");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) protocol to be used to communicate through a proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_PROTOCOL));
        OptionBuilder.withArgName("host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) host name of the proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_HOST));
        OptionBuilder.withArgName("port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) port of the proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_HOST));
        OptionBuilder.withArgName("non-proxy-host(s)");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) list of hosts that should not use the proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_NON_PROXY_HOST));
        OptionBuilder.withArgName("username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) username used to authenticate at the proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_USERNAME));
        OptionBuilder.withArgName("password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("(Optional and only valid when providing a proxy host and port) password used to authenticate at the proxy server.");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create(OPTION_PROXY_PASSWORD));
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.getArgList().isEmpty() || cmd.getArgList().contains(COMMAND_HELP)) {
                SdkConverterCLI.printHelp(options);
                System.exit(0);
            }
            ArrayList<PlatformType> platforms = new ArrayList<PlatformType>();
            String platformParam = cmd.getOptionValue(OPTION_PLATFORMS);
            if (platformParam != null && !platformParam.isEmpty()) {
                String[] platformNames;
                for (String platformName : platformNames = platformParam.split(",")) {
                    platforms.add(PlatformType.valueOf(platformName));
                }
            }
            if (platforms.isEmpty()) {
                try {
                    platforms.add(PlatformType.getCurrent());
                }
                catch (Exception e) {
                    System.err.println("Unsupported OS type. Provide manually using 'platform' parameter.");
                    System.exit(1);
                }
            }
            for (String command : cmd.getArgList()) {
                if (COMMAND_LIST.equals(command) || COMMAND_DOWNLOAD.equals(command) || COMMAND_CONVERT.equals(command) || COMMAND_DEPLOY.equals(command)) continue;
                System.err.println("Unsupported command '" + command + "'.");
                System.exit(1);
            }
            if (cmd.getArgList().contains(COMMAND_DOWNLOAD) && !cmd.getArgList().contains(COMMAND_CONVERT) && cmd.getArgList().contains(COMMAND_DEPLOY)) {
                System.err.println("Downloading and deploying without conversion doesn't make much sense.");
                System.exit(1);
            }
            if (cmd.getArgList().contains(COMMAND_DOWNLOAD) && !cmd.getArgList().contains(COMMAND_CONVERT) && !cmd.hasOption(OPTION_FDK_DIR)) {
                System.err.println("Parameter 'fdkDir' required for task 'download' without conversion.");
                System.exit(1);
            }
            if (cmd.getArgList().contains(COMMAND_CONVERT) && !cmd.getArgList().contains(COMMAND_DEPLOY) && !cmd.hasOption(OPTION_MAVEN_DIR)) {
                System.err.println("Parameter 'mavenDir' required for task 'convert' without deployment.");
                System.exit(1);
            }
            if (!(!cmd.getArgList().contains(COMMAND_DOWNLOAD) || cmd.hasOption(OPTION_FLEX_VERSION) || cmd.hasOption(OPTION_FLASH_VERSIONS) || cmd.hasOption(OPTION_AIT_VERSION) || cmd.hasOption(OPTION_FONTKIT))) {
                System.err.println("At least one of the parameters 'flexVersion', 'flashVersions', 'airVersion' or 'fontkit' required for task 'download'.");
                System.exit(1);
            }
            File fdkDir = cmd.hasOption(OPTION_FDK_DIR) ? new File(cmd.getOptionValue(OPTION_FDK_DIR)) : SdkConverterCLI.getTempDir("FLEX-DOWNLOAD-");
            File mavenDir = cmd.hasOption(OPTION_MAVEN_DIR) ? new File(cmd.getOptionValue(OPTION_MAVEN_DIR)) : SdkConverterCLI.getTempDir("FLEX-MAVEN-");
            ProxySettings proxySettings = SdkConverterCLI.getProxySettings(cmd);
            ProxySettings.setProxySettings(proxySettings);
            if (cmd.getArgList().contains(COMMAND_LIST)) {
                System.out.println("-----------------------------------------------");
                System.out.println("- Available downloads");
                System.out.println("-----------------------------------------------");
                DownloadRetriever retriever = new DownloadRetriever();
                System.out.println("Apache Flex:");
                ArrayList<DefaultArtifactVersion> versions = new ArrayList<DefaultArtifactVersion>(retriever.getAvailableVersions(SdkType.FLEX).keySet());
                Collections.sort(versions);
                for (DefaultArtifactVersion defaultArtifactVersion : versions) {
                    System.out.println(" - " + defaultArtifactVersion.toString());
                }
                System.out.println();
                System.out.println("Adobe Flash:");
                versions = new ArrayList<DefaultArtifactVersion>(retriever.getAvailableVersions(SdkType.FLASH).keySet());
                Collections.sort(versions);
                for (DefaultArtifactVersion defaultArtifactVersion : versions) {
                    System.out.println(" - " + defaultArtifactVersion.toString());
                }
                System.out.println();
                System.out.println("Adobe AIR:");
                Map<DefaultArtifactVersion, Collection<PlatformType>> versionData = retriever.getAvailableVersions(SdkType.AIR);
                versions = new ArrayList<DefaultArtifactVersion>(versionData.keySet());
                Collections.sort(versions);
                for (DefaultArtifactVersion version : versions) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" - ").append(version.toString()).append(" (");
                    boolean firstOption = true;
                    for (PlatformType platformType : versionData.get(version)) {
                        if (!firstOption) {
                            sb.append(", ");
                        }
                        sb.append(platformType.name());
                        firstOption = false;
                    }
                    sb.append(")");
                    System.out.println(sb.toString());
                }
            }
            if (cmd.getArgList().contains(COMMAND_DOWNLOAD)) {
                String string;
                String flashVersions;
                System.out.println("-----------------------------------------------");
                System.out.println("- Downloading");
                System.out.println("-----------------------------------------------");
                DownloadRetriever retriever = new DownloadRetriever();
                String flexVersion = cmd.getOptionValue(OPTION_FLEX_VERSION, null);
                if (flexVersion != null) {
                    System.out.println("- Downloading Flex SDK version: " + flexVersion + " to directory: " + fdkDir.getAbsolutePath());
                    File fdkDownloadDirectory = retriever.retrieve(SdkType.FLEX, flexVersion);
                    SdkConverterCLI.mergeDirectories(fdkDownloadDirectory, fdkDir);
                    File file = retriever.retrieve(SdkType.SWFOBJECT);
                    SdkConverterCLI.mergeDirectories(file, fdkDir);
                }
                if (!(flashVersions = cmd.getOptionValue(OPTION_FLASH_VERSIONS, "")).isEmpty()) {
                    for (String flashVersion : flashVersions.split(",")) {
                        System.out.println("- Downloading Flash SDK version: " + flashVersion + " to directory: " + fdkDir.getAbsolutePath());
                        File flashDownloadDiretory = retriever.retrieve(SdkType.FLASH, flashVersion);
                        SdkConverterCLI.mergeDirectories(flashDownloadDiretory, fdkDir);
                    }
                }
                if (!(string = cmd.getOptionValue(OPTION_AIT_VERSION, "")).isEmpty()) {
                    for (PlatformType platformType : platforms) {
                        System.out.println("- Downloading Air SDK version: " + string + " and platform " + platformType.name() + " to directory: " + fdkDir.getAbsolutePath());
                        File airDownloadDirectory = retriever.retrieve(SdkType.AIR, string, platformType);
                        SdkConverterCLI.mergeDirectories(airDownloadDirectory, fdkDir);
                    }
                }
                if (cmd.hasOption(OPTION_FONTKIT)) {
                    System.out.println("- Downloading Flex Fontkit libraries to directory: " + fdkDir.getAbsolutePath());
                    File fontkitDownloadDirectory = retriever.retrieve(SdkType.FONTKIT);
                    SdkConverterCLI.mergeDirectories(fontkitDownloadDirectory, fdkDir);
                }
                System.out.println("Finished downloads.");
            }
            if (cmd.getArgList().contains(COMMAND_CONVERT)) {
                System.out.println("-----------------------------------------------");
                System.out.println("- Conversion");
                System.out.println("-----------------------------------------------");
                System.out.println("- Converting Flex SDK from " + fdkDir.getAbsolutePath() + " to " + mavenDir.getAbsolutePath());
                FlexConverter flexConverter = new FlexConverter(fdkDir, mavenDir);
                flexConverter.convert();
                System.out.println("- Converting Flash SDKs from " + fdkDir.getAbsolutePath() + " to " + mavenDir.getAbsolutePath());
                FlashConverter flashConverter = new FlashConverter(fdkDir, mavenDir);
                flashConverter.convert();
                System.out.println("- Converting Air SDK from " + fdkDir.getAbsolutePath() + " to " + mavenDir.getAbsolutePath());
                AirConverter airConverter = new AirConverter(fdkDir, mavenDir);
                airConverter.convert();
                System.out.println("- Converting Fontkit libraries from " + fdkDir.getAbsolutePath() + " to " + mavenDir.getAbsolutePath());
                FontkitConverter fontkitConverter = new FontkitConverter(fdkDir, mavenDir);
                fontkitConverter.convert();
                System.out.println("- Converting Wrappers from " + fdkDir.getAbsolutePath() + " to " + mavenDir.getAbsolutePath());
                WrapperConverter wrapperConverter = new WrapperConverter(fdkDir, mavenDir);
                wrapperConverter.convert();
                System.out.println("Finished conversion.");
            }
            if (cmd.getArgList().contains(COMMAND_DEPLOY)) {
                System.out.println("-----------------------------------------------");
                System.out.println("- Deployment");
                System.out.println("-----------------------------------------------");
                if (!cmd.hasOption(OPTION_REPO_URL)) {
                    System.err.println("Parameter 'repoUrl' required for task 'deploy'.");
                    System.exit(1);
                }
                String repoUrl = cmd.getOptionValue(OPTION_REPO_URL);
                String repoUsername = cmd.getOptionValue(OPTION_REPO_USERNAME, null);
                String repoPassword = cmd.getOptionValue(OPTION_REPO_PASSWORD, null);
                System.out.println("- Deploying libraries to " + repoUrl + " from " + mavenDir.getAbsolutePath());
                AetherDeployer aetherDeployer = new AetherDeployer(mavenDir, repoUrl, repoUsername, repoPassword);
                aetherDeployer.deploy();
                System.out.println("Finished deploying.");
            }
            System.out.println("-----------------------------------------------");
        }
        catch (ParseException e) {
            System.err.println("Parsing failed. Reason: " + e.getMessage());
            SdkConverterCLI.printHelp(options);
        }
    }

    protected static void printHelp(Options options) {
        String headerText = "Commands: \nIf the parameters 'fdkDir' and 'mavenDir' are not specified, the Converter creates two temporary directories in your systems temp directory and uses these for the follwoing commands.\n - list:\nList all available versions and platforms (for download)\n - download:\nDownload the selected versions of FDK parts specified by 'flexVersion', 'flashVersions', 'airVersion' and 'fontkit' and creates an FDK in the directory specified by 'fdkDir'. If 'airVersion' is specified, the 'platforms' parameter specifies the platforms for which the given AIR SDK should be downloaded, if not specified the current systems platform is used. \n - convert:\nConvert the FDK located in 'fdkDir' into a mavenized form at 'mavenDir'.\n - deploy:\nDeploy the maven artifacts located in 'mavenDir', to the remote maven repository specified with 'repoUrl'. If the 'repoUsername' and 'repoPassword' parameters are specified, use these credentials for authenticating at the remote system.\nOptions:";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java -jar apache-flex-sdk-converter.jar [-proxyProtocol <http|https|socks> -proxyHost <host> -proxyPort <port> [-proxyNonProxyHost <non-proxy-host(s)>] [-proxyUser <username> -proxyPassword <password>]] [list] [-fdkDir <fdkDir>] [-mavenDir <mavenDir>] [[-flexVersion <version>] [-flashVersions <version(s)>] [-airVersion <version> [-platforms <platform(s)>]] [-fontkit] download] [convert] [-repoUrl <url> [-repoUsername <username> -repoPassword <password>] deploy]", headerText, options, "");
    }

    protected static File getTempDir(String prefix) throws IOException {
        File tempFile = File.createTempFile(prefix, ".TMP");
        tempFile.delete();
        File tempDir = new File(tempFile.getParentFile(), tempFile.getName().substring(0, tempFile.getName().length() - 4));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    protected static ProxySettings getProxySettings(CommandLine cmd) {
        if (cmd.hasOption(OPTION_PROXY_HOST)) {
            String protocol = cmd.getOptionValue(OPTION_PROXY_PROTOCOL);
            String host = cmd.getOptionValue(OPTION_PROXY_HOST);
            String nonProxyHost = cmd.getOptionValue(OPTION_PROXY_NON_PROXY_HOST);
            int port = cmd.hasOption(OPTION_PROXY_PORT) ? Integer.valueOf(cmd.getOptionValue(OPTION_PROXY_PORT)) : 0;
            String username = cmd.getOptionValue(OPTION_PROXY_USERNAME);
            String password = cmd.getOptionValue(OPTION_PROXY_PASSWORD);
            return new ProxySettings(protocol, host, port, nonProxyHost, username, password);
        }
        return null;
    }

    protected static void mergeDirectories(File sourceDir, File targetDir) throws IOException {
        FileUtils.copyDirectory(sourceDir, targetDir);
    }
}

