/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.configuration.ConfigManager;
import org.apache.felix.webconsole.internal.configuration.MetaTypeServiceSupport;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.configuration.MetatypePropertyDescriptor;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigAdminSupport {
    private static final String PROPERTY_FACTORYCONFIG_NAMEHINT = "webconsole.configurationFactory.nameHint";
    private static final Set<String> CONFIG_PROPERTIES_HIDE = new HashSet<String>();
    private static final Pattern NAMEHINT_PLACEHOLER_REGEXP;
    private final BundleContext bundleContext;
    private final ConfigurationAdmin service;
    private final ConfigManager configManager;

    ConfigAdminSupport(ConfigManager configManager, BundleContext bundleContext, Object service) {
        this.configManager = configManager;
        this.bundleContext = bundleContext;
        this.service = (ConfigurationAdmin)service;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private MetaTypeServiceSupport getMetaTypeSupport() {
        Object metaTypeService = this.configManager.getService("org.osgi.service.metatype.MetaTypeService");
        if (metaTypeService != null) {
            return new MetaTypeServiceSupport(this.getBundleContext(), metaTypeService);
        }
        return null;
    }

    final Configuration getConfiguration(String pid) {
        if (pid != null) {
            try {
                String filter = "(service.pid=" + pid + ')';
                Configuration[] configs = this.service.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    final Configuration getConfiguration(String pid, String factoryPid) throws IOException {
        if (factoryPid != null && (pid == null || pid.equals("[Temporary PID replaced by real PID upon save]"))) {
            return this.service.createFactoryConfiguration(factoryPid, null);
        }
        return this.service.getConfiguration(pid, null);
    }

    Configuration getPlaceholderConfiguration(String factoryPid) {
        return new PlaceholderConfiguration(factoryPid);
    }

    String getPlaceholderPid() {
        return "[Temporary PID replaced by real PID upon save]";
    }

    String applyConfiguration(HttpServletRequest request, String pid, boolean isUpdate) throws IOException {
        if (request.getParameter("delete") != null) {
            if (!"[Temporary PID replaced by real PID upon save]".equals(pid)) {
                this.configManager.log("applyConfiguration: Deleting configuration " + pid);
                Configuration config = this.service.getConfiguration(pid, null);
                config.delete();
            }
            return null;
        }
        String factoryPid = request.getParameter("factoryPid");
        Configuration config = null;
        String propertyList = request.getParameter("propertylist");
        if (propertyList != null) {
            String location;
            MetaTypeServiceSupport mtss;
            config = this.getConfiguration(pid, factoryPid);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            Map<Object, Object> adMap = (mtss = this.getMetaTypeSupport()) != null ? mtss.getAttributeDefinitionMap(config, null) : new HashMap();
            StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
            ArrayList<String> propsToKeep = new ArrayList<String>();
            while (propTokens.hasMoreTokens()) {
                String prop;
                String propName = propTokens.nextToken();
                String paramName = "action".equals(propName) || "delete".equals(propName) || "apply".equals(propName) || "propertylist".equals(propName) ? '$' + propName : propName;
                propsToKeep.add(propName);
                PropertyDescriptor ad = (PropertyDescriptor)adMap.get(propName);
                if (ad == null) {
                    Object currentValue = ((Dictionary)props).get(propName);
                    ad = MetaTypeSupport.createAttributeDefinition(propName, currentValue);
                }
                int attributeType = MetaTypeSupport.getAttributeType(ad);
                if (ad == null || ad.getCardinality() == 0 && (attributeType == 1 || attributeType == 12)) {
                    prop = request.getParameter(paramName);
                    if (prop == null || attributeType == 12 && "unmodified".equals(prop)) continue;
                    ((Dictionary)props).put(propName, prop);
                    continue;
                }
                if (ad.getCardinality() == 0) {
                    prop = request.getParameter(paramName);
                    if (prop == null) continue;
                    try {
                        ((Dictionary)props).put(propName, MetaTypeSupport.toType(attributeType, prop));
                    }
                    catch (NumberFormatException nfe) {
                        ((Dictionary)props).put(propName, prop);
                    }
                    continue;
                }
                Vector<Object> vec = new Vector<Object>();
                boolean formatError = false;
                String[] properties = request.getParameterValues(paramName);
                if (properties != null) {
                    if (attributeType == 12) {
                        MetaTypeSupport.setPasswordProps(vec, properties, ((Dictionary)props).get(propName));
                    } else {
                        for (int i = 0; i < properties.length; ++i) {
                            try {
                                vec.add(MetaTypeSupport.toType(attributeType, properties[i]));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                vec.add(properties[i]);
                                formatError = true;
                            }
                        }
                    }
                }
                if (formatError) {
                    Vector<String> newVec = new Vector<String>();
                    for (Object e : vec) {
                        newVec.add(e.toString());
                    }
                    vec = newVec;
                }
                int maxSize = Math.abs(ad.getCardinality());
                if (vec.size() > maxSize && maxSize > 0) {
                    vec.setSize(maxSize);
                }
                if (ad.getCardinality() < 0) {
                    if (vec.isEmpty()) {
                        ((Dictionary)props).remove(propName);
                        continue;
                    }
                    ((Dictionary)props).put(propName, vec);
                    continue;
                }
                ((Dictionary)props).put(propName, MetaTypeSupport.toArray(formatError ? 1 : attributeType, vec));
            }
            if (!isUpdate) {
                Hashtable updateProps = new Hashtable(((Dictionary)props).size());
                Enumeration e = ((Dictionary)props).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!propsToKeep.contains(key)) continue;
                    ((Dictionary)updateProps).put(key, ((Dictionary)props).get(key));
                }
                props = updateProps;
            }
            if ((location = request.getParameter("$location")) == null || location.trim().length() == 0 || "??unbound:bundle/location".equals(location)) {
                if (config.getBundleLocation() != null) {
                    config.setBundleLocation(null);
                    if (config.getBundleLocation() != null) {
                        config.setBundleLocation("??invalid:bundle/location");
                        config.setBundleLocation(null);
                    }
                }
            } else if (config.getBundleLocation() == null || !config.getBundleLocation().equals(location)) {
                config.setBundleLocation(location);
            }
            config.update(props);
        }
        return config != null ? config.getPid() : "";
    }

    void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter(pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                this.configManager.log("Error reading configuration PID " + pid, e);
            }
        }
    }

    void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws IOException {
        json.key("pid");
        json.value(pid);
        if (pidFilter != null) {
            json.key("pidFilter");
            json.value(pidFilter);
        }
        Hashtable<String, Object> props = null;
        if (config != null) {
            props = config.getProperties();
        }
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        boolean doSimpleMerge = true;
        MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
        if (mtss != null) {
            ObjectClassDefinition ocd = null;
            if (config != null) {
                ocd = mtss.getObjectClassDefinition(config, locale);
            }
            if (ocd == null) {
                ocd = mtss.getObjectClassDefinition(pid, locale);
            }
            if (ocd != null) {
                mtss.mergeWithMetaType(props, ocd, json, CONFIG_PROPERTIES_HIDE);
                doSimpleMerge = false;
            }
        }
        if (doSimpleMerge) {
            json.key("title").value(pid);
            json.key("description").value("This form is automatically generated from existing properties because no property descriptors are available for this configuration. This may be cause by the absence of the OSGi Metatype Service or the absence of a MetaType descriptor for this configuration.");
            json.key("properties").object();
            Enumeration pe = ((Dictionary)props).keys();
            while (pe.hasMoreElements()) {
                String id = (String)pe.nextElement();
                if (id.equals("service.pid") || id.equals("service.description") || id.equals("service.id") || id.equals("service.vendor") || id.equals("service.bundleLocation") || id.equals("service.factoryPid")) continue;
                Object value = ((Dictionary)props).get(id);
                PropertyDescriptor ad = MetaTypeServiceSupport.createAttributeDefinition(id, value);
                json.key(id);
                MetaTypeServiceSupport.attributeToJson(json, ad, value);
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws IOException {
        String location;
        String bundleLocation;
        if (config.getFactoryPid() != null) {
            json.key("factoryPid");
            json.value(config.getFactoryPid());
        }
        if ("??unbound:bundle/location".equals(bundleLocation = config.getBundleLocation())) {
            bundleLocation = null;
        }
        if (bundleLocation == null) {
            location = "";
        } else {
            Bundle bundle = MetaTypeServiceSupport.getBundle(this.getBundleContext(), bundleLocation);
            if (bundle == null) {
                location = bundleLocation;
            } else {
                Dictionary headers = bundle.getHeaders(locale);
                String name = (String)headers.get("Bundle-Name");
                location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ')';
                Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                location = location + ", Version " + v.toString();
            }
        }
        json.key("bundleLocation");
        json.value(location);
        String pid = config.getPid();
        String serviceLocation = "";
        try {
            ServiceReference[] refs = this.getBundleContext().getServiceReferences((String)null, "(&(objectClass=" + ManagedService.class.getName() + ")(" + "service.pid" + '=' + pid + "))");
            if (refs != null && refs.length > 0) {
                serviceLocation = refs[0].getBundle().getLocation();
            }
        }
        catch (Throwable t) {
            this.configManager.log("Error getting service associated with configuration " + pid, t);
        }
        json.key("bundle_location");
        json.value(bundleLocation);
        json.key("service_location");
        json.value(serviceLocation);
    }

    private final Bundle getBoundBundle(Configuration config) {
        if (null == config) {
            return null;
        }
        String location = config.getBundleLocation();
        if (null == location) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(location)) continue;
            return bundles[i];
        }
        return null;
    }

    final void listConfigurations(JSONWriter jw, String pidFilter, String locale, Locale loc) {
        try {
            SortedMap<String, String> optionsPlain = this.getServices(ManagedService.class.getName(), pidFilter, locale, true);
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null) {
                this.addMetaTypeNames(optionsPlain, mtss.getPidObjectClasses(locale), pidFilter, "service.pid");
            }
            Configuration[] cfgs = this.service.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid) || !ConfigManager.isAllowedPid(pid)) continue;
                if (mtss != null) {
                    try {
                        ObjectClassDefinition ocd = mtss.getObjectClassDefinition(cfgs[i], locale);
                        if (ocd != null) {
                            optionsPlain.put(pid, ocd.getName());
                            continue;
                        }
                    }
                    catch (IllegalArgumentException ocd) {
                        // empty catch block
                    }
                }
                optionsPlain.put(pid, pid);
            }
            jw.key("pids");
            jw.array();
            for (String id : optionsPlain.keySet()) {
                Object name = optionsPlain.get(id);
                Configuration config = this.getConfiguration(id);
                jw.object();
                jw.key("id").value(id);
                jw.key("name").value(name);
                if (null != config) {
                    Bundle bundle;
                    jw.key("has_config").value(true);
                    String fpid = config.getFactoryPid();
                    if (null != fpid) {
                        jw.key("fpid").value(fpid);
                        String val = ConfigAdminSupport.getConfigurationFactoryNameHint(config, mtss);
                        if (val != null) {
                            jw.key("nameHint").value(val);
                        }
                    }
                    if (null != (bundle = this.getBoundBundle(config))) {
                        jw.key("bundle").value(bundle.getBundleId());
                        jw.key("bundle_name").value(Util.getName(bundle, loc));
                    }
                }
                jw.endObject();
            }
            jw.endArray();
        }
        catch (Exception e) {
            this.configManager.log("listConfigurations: Unexpected problem encountered", e);
        }
    }

    private static final String getConfigurationFactoryNameHint(Configuration config, MetaTypeServiceSupport mtss) {
        Map<String, MetatypePropertyDescriptor> adMap;
        Dictionary props = config.getProperties();
        Map<String, MetatypePropertyDescriptor> map = adMap = mtss != null ? mtss.getAttributeDefinitionMap(config, null) : null;
        if (null == adMap) {
            return null;
        }
        String nameHint = ConfigAdminSupport.getConfigurationPropertyValueOrDefault(PROPERTY_FACTORYCONFIG_NAMEHINT, props, adMap);
        if (nameHint == null) {
            return null;
        }
        Matcher matcher = NAMEHINT_PLACEHOLER_REGEXP.matcher(nameHint);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String value = ConfigAdminSupport.getConfigurationPropertyValueOrDefault(propertyName, props, adMap);
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, ConfigAdminSupport.matcherQuoteReplacement(value));
        }
        matcher.appendTail(sb);
        nameHint = sb.toString().trim();
        if (nameHint.length() == 0) {
            return null;
        }
        return nameHint;
    }

    private static String getConfigurationPropertyValueOrDefault(String propertyName, Dictionary<String, Object> props, Map<String, MetatypePropertyDescriptor> adMap) {
        Object value = props.get(propertyName);
        if (value != null) {
            if (value.getClass().isArray()) {
                StringBuffer valueString = new StringBuffer();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (i > 0) {
                        valueString.append(", ");
                    }
                    valueString.append(Array.get(value, i));
                }
                return valueString.toString();
            }
            return value.toString();
        }
        PropertyDescriptor ad = adMap.get(propertyName);
        if (ad != null && ad.getDefaultValue() != null && ad.getDefaultValue().length == 1) {
            return ad.getDefaultValue()[0];
        }
        return null;
    }

    private static String matcherQuoteReplacement(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '$' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    final void listFactoryConfigurations(JSONWriter jw, String pidFilter, String locale) {
        try {
            SortedMap<String, String> optionsFactory = this.getServices(ManagedServiceFactory.class.getName(), pidFilter, locale, true);
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null) {
                this.addMetaTypeNames(optionsFactory, mtss.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            }
            jw.key("fpids");
            jw.array();
            for (String id : optionsFactory.keySet()) {
                Object name = optionsFactory.get(id);
                jw.object();
                jw.key("id").value(id);
                jw.key("name").value(name);
                jw.endObject();
            }
            jw.endArray();
        }
        catch (Exception e) {
            this.configManager.log("listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    SortedMap<String, String> getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            ObjectClassDefinition ocd;
            String pid;
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String) || !ConfigManager.isAllowedPid((String)pidObject)) continue;
            String name = pid = (String)pidObject;
            boolean haveOcd = !ocdRequired;
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null && (ocd = mtss.getObjectClassDefinition(refs[i].getBundle(), pid, locale)) != null) {
                name = ocd.getName();
                haveOcd = true;
            }
            if (!haveOcd) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map<String, String> pidMap, Map<String, ObjectClassDefinition> ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        for (Map.Entry<String, ObjectClassDefinition> ociEntry : ocdCollection.entrySet()) {
            String pid = ociEntry.getKey();
            ObjectClassDefinition ocd = ociEntry.getValue();
            if (filter == null) {
                pidMap.put(pid, ocd.getName());
                continue;
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (!filter.match(props)) continue;
            pidMap.put(pid, ocd.getName());
        }
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        return this.service.listConfigurations(filter);
    }

    static {
        CONFIG_PROPERTIES_HIDE.add(PROPERTY_FACTORYCONFIG_NAMEHINT);
        CONFIG_PROPERTIES_HIDE.add("service.bundleLocation");
        CONFIG_PROPERTIES_HIDE.add("service.factoryPid");
        CONFIG_PROPERTIES_HIDE.add("service.pid");
        NAMEHINT_PLACEHOLER_REGEXP = Pattern.compile("\\{([^\\{\\}]*)}");
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return "[Temporary PID replaced by real PID upon save]";
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary<String, Object> getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary<String, ?> properties) {
        }

        public void delete() {
        }

        public long getChangeCount() {
            return 0L;
        }
    }
}

