/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class PluginHolder
implements ServiceListener {
    private final BundleContext bundleContext;
    private final Map plugins;
    private ServletContext servletContext;
    private String defaultPluginLabel;

    PluginHolder(BundleContext context) {
        this.bundleContext = context;
        this.plugins = new HashMap();
    }

    void open() {
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=javax.servlet.Servlet)");
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed registering for Servlet service events: " + ise.getMessage());
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences("javax.servlet.Servlet", null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    this.serviceAdded(refs[i]);
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed getting existing Servlet services: " + ise.getMessage());
        }
    }

    void close() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        Plugin[] plugin = this.getPlugins();
        for (int i = 0; i < plugin.length; ++i) {
            plugin[i].dispose();
        }
        this.plugins.clear();
        this.defaultPluginLabel = null;
    }

    String getDefaultPluginLabel() {
        return this.defaultPluginLabel;
    }

    void setDefaultPluginLabel(String defaultPluginLabel) {
        this.defaultPluginLabel = defaultPluginLabel;
    }

    void addInternalPlugin(OsgiManager osgiManager, String pluginClassName, String label) {
        InternalPlugin plugin = new InternalPlugin(this, osgiManager, pluginClassName, label);
        this.addPlugin(label, plugin);
    }

    void addOsgiManagerPlugin(AbstractWebConsolePlugin consolePlugin) {
        String label = consolePlugin.getLabel();
        Plugin plugin = new Plugin(this, consolePlugin, label);
        this.addPlugin(label, plugin);
    }

    void removeOsgiManagerPlugin(String label) {
        this.removePlugin(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractWebConsolePlugin getPlugin(String label) {
        AbstractWebConsolePlugin consolePlugin = null;
        if (label != null && label.length() > 0) {
            Plugin plugin;
            Map map = this.plugins;
            synchronized (map) {
                plugin = (Plugin)this.plugins.get(label);
            }
            if (plugin != null) {
                consolePlugin = plugin.getConsolePlugin();
            }
        } else {
            Plugin[] plugins = this.getPlugins();
            for (int i = 0; i < plugins.length && consolePlugin == null; ++i) {
                consolePlugin = plugins[i].getConsolePlugin();
            }
        }
        return consolePlugin;
    }

    Map getLocalizedLabelMap(ResourceBundleManager resourceBundleManager, Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        Plugin[] plugins = this.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin plugin = plugins[i];
            if (!plugin.isEnabled()) continue;
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            map.put(label, title);
        }
        return map;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setServletContext(ServletContext servletContext) {
        Plugin[] plugin = this.getPlugins();
        if (servletContext != null) {
            this.servletContext = servletContext;
            for (int i = 0; i < plugin.length; ++i) {
                try {
                    plugin[i].init();
                    continue;
                }
                catch (ServletException se) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < plugin.length; ++i) {
                try {
                    plugin[i].destroy();
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.servletContext = null;
        }
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.serviceAdded(event.getServiceReference());
                break;
            }
            case 4: {
                this.serviceRemoved(event.getServiceReference());
                break;
            }
        }
    }

    private void serviceAdded(ServiceReference serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.addPlugin(label, new ServletPlugin(this, serviceReference, label));
        }
    }

    private void serviceRemoved(ServiceReference serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.removePlugin(label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugin(String label, Plugin plugin) {
        Map map = this.plugins;
        synchronized (map) {
            this.plugins.put(label, plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlugin(String label) {
        Plugin oldPlugin;
        Map map = this.plugins;
        synchronized (map) {
            oldPlugin = (Plugin)this.plugins.remove(label);
        }
        if (oldPlugin != null) {
            oldPlugin.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin[] getPlugins() {
        Map map = this.plugins;
        synchronized (map) {
            return this.plugins.values().toArray(new Plugin[this.plugins.size()]);
        }
    }

    static String getProperty(ServiceReference service, String propertyName) {
        Object property = service.getProperty(propertyName);
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }

    static class InternalPlugin
    extends Plugin {
        final String pluginClassName;
        final OsgiManager osgiManager;
        AbstractWebConsolePlugin plugin;
        boolean doLog = true;

        protected InternalPlugin(PluginHolder holder, OsgiManager osgiManager, String pluginClassName, String label) {
            super(holder, label);
            this.osgiManager = osgiManager;
            this.pluginClassName = pluginClassName;
        }

        protected final boolean isEnabled() {
            return !this.osgiManager.isPluginDisabled(this.pluginClassName);
        }

        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            block6: {
                if (null == this.plugin) {
                    if (!this.isEnabled()) {
                        if (this.doLog) {
                            this.osgiManager.log(3, "Ignoring plugin " + this.pluginClassName + ": Disabled by configuration");
                            this.doLog = false;
                        }
                        return null;
                    }
                    try {
                        Class<?> pluginClass = this.getClass().getClassLoader().loadClass(this.pluginClassName);
                        this.plugin = (AbstractWebConsolePlugin)((Object)pluginClass.newInstance());
                        if (this.plugin instanceof OsgiManagerPlugin) {
                            ((OsgiManagerPlugin)((Object)this.plugin)).activate(this.getBundle().getBundleContext());
                        }
                        this.doLog = true;
                    }
                    catch (Throwable t) {
                        this.plugin = null;
                        if (!this.doLog) break block6;
                        this.osgiManager.log(2, "Failed to instantiate plugin " + this.pluginClassName, t);
                        this.doLog = false;
                    }
                }
            }
            return this.plugin;
        }

        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
            if (consolePlugin == this.plugin) {
                this.plugin = null;
            }
            if (consolePlugin instanceof OsgiManagerPlugin) {
                ((OsgiManagerPlugin)((Object)consolePlugin)).deactivate();
            }
            super.doUngetConsolePlugin(consolePlugin);
        }
    }

    private static class ServletPlugin
    extends Plugin {
        private final ServiceReference serviceReference;

        ServletPlugin(PluginHolder holder, ServiceReference serviceReference, String label) {
            super(holder, label);
            this.serviceReference = serviceReference;
        }

        Bundle getBundle() {
            return this.serviceReference.getBundle();
        }

        protected String doGetTitle() {
            String title = PluginHolder.getProperty(this.serviceReference, "felix.webconsole.title");
            if (title != null) {
                return title;
            }
            this.setTitle(this.getLabel());
            return super.doGetTitle();
        }

        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            Object service = this.getHolder().getBundleContext().getService(this.serviceReference);
            if (service instanceof Servlet) {
                AbstractWebConsolePlugin servlet = service instanceof AbstractWebConsolePlugin ? (AbstractWebConsolePlugin)((Object)service) : new WebConsolePluginAdapter(this.getLabel(), (Servlet)service, this.serviceReference);
                return servlet;
            }
            return null;
        }

        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
            this.getHolder().getBundleContext().ungetService(this.serviceReference);
        }

        public String getInitParameter(String name) {
            Object property = this.serviceReference.getProperty(name);
            if (property != null && !property.getClass().isArray()) {
                return property.toString();
            }
            return super.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            final String[] keys = this.serviceReference.getPropertyKeys();
            return new Enumeration(){
                int idx = 0;

                public boolean hasMoreElements() {
                    return this.idx < keys.length;
                }

                public Object nextElement() {
                    if (this.hasMoreElements()) {
                        return keys[this.idx++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private static class Plugin
    implements ServletConfig {
        private final PluginHolder holder;
        private final String label;
        private String title;
        private AbstractWebConsolePlugin consolePlugin;

        protected Plugin(PluginHolder holder, String label) {
            this.holder = holder;
            this.label = label;
        }

        protected Plugin(PluginHolder holder, AbstractWebConsolePlugin plugin, String label) {
            this(holder, label);
            if (plugin == null) {
                throw new NullPointerException("plugin");
            }
            this.consolePlugin = plugin;
        }

        void init() throws ServletException {
            if (this.consolePlugin != null) {
                this.consolePlugin.init(this);
            }
        }

        void destroy() {
            if (this.consolePlugin != null) {
                this.consolePlugin.destroy();
            }
        }

        final void dispose() {
            if (this.consolePlugin != null) {
                try {
                    this.consolePlugin.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.doUngetConsolePlugin(this.consolePlugin);
                this.consolePlugin = null;
            }
        }

        protected PluginHolder getHolder() {
            return this.holder;
        }

        Bundle getBundle() {
            return this.getHolder().getBundleContext().getBundle();
        }

        final String getLabel() {
            return this.label;
        }

        protected void setTitle(String title) {
            this.title = title;
        }

        final String getTitle() {
            if (this.title == null) {
                String title = this.doGetTitle();
                this.title = title == null ? this.getLabel() : title;
            }
            return this.title;
        }

        protected String doGetTitle() {
            AbstractWebConsolePlugin consolePlugin = this.getConsolePlugin();
            return consolePlugin != null ? consolePlugin.getTitle() : null;
        }

        final AbstractWebConsolePlugin getConsolePlugin() {
            AbstractWebConsolePlugin consolePlugin;
            if (this.consolePlugin == null && (consolePlugin = this.doGetConsolePlugin()) != null) {
                try {
                    this.consolePlugin = consolePlugin;
                    this.init();
                }
                catch (ServletException se) {
                    this.consolePlugin = null;
                }
            }
            return this.consolePlugin;
        }

        protected boolean isEnabled() {
            return true;
        }

        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            return this.consolePlugin;
        }

        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }

        public ServletContext getServletContext() {
            return this.getHolder().getServletContext();
        }

        public String getServletName() {
            return this.getTitle();
        }
    }
}

