/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.plugins.upnp.internal.Base64;
import org.apache.felix.webconsole.plugins.upnp.internal.Hex;
import org.apache.felix.webconsole.plugins.upnp.internal.Serializer;
import org.apache.felix.webconsole.plugins.upnp.internal.SessionObject;
import org.apache.felix.webconsole.plugins.upnp.internal.WebConsolePlugin;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPIcon;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;
import org.osgi.util.tracker.ServiceTracker;

public final class ControlServlet
extends HttpServlet {
    private static final long serialVersionUID = -5789642544511401813L;
    private static final SimpleDateFormat DATA_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private final HashMap devices = new HashMap(10);
    private final HashMap icons = new HashMap(10);
    private final Object cacheLock = new Object();
    private final Map sessions = Collections.synchronizedMap(new HashMap(10));
    private final ServiceTracker tracker;
    private final BundleContext bc;
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private final WebConsolePlugin plugin;
    static /* synthetic */ Class class$java$lang$String;

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String udn = request.getParameter("icon");
        if (udn != null) {
            UPnPIcon icon = this.getIcon(udn);
            if (icon == null) {
                response.sendError(404);
            } else if (request.getDateHeader("If-Modified-Since") > 0L) {
                response.setStatus(304);
            } else {
                int read;
                response.setDateHeader("Last-Modified", LAST_MODIFIED);
                InputStream in = icon.getInputStream();
                if (null == in) {
                    response.setStatus(404);
                    return;
                }
                String mime = icon.getMimeType();
                if (mime != null) {
                    response.setContentType(mime);
                }
                ServletOutputStream out = response.getOutputStream();
                int size = icon.getSize();
                if (size > 0) {
                    response.setContentLength(size);
                }
                while (-1 != (read = in.read())) {
                    out.write(read);
                }
            }
        }
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            JSONObject json = new JSONObject();
            String method = request.getParameter("action");
            if ("listDevices".equals(method)) {
                this.getSession(request).unsubscribe();
                ServiceReference[] refs = this.tracker.getServiceReferences();
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    JSONObject deviceJSON;
                    if (refs[i] == null || refs[i].getProperty("UPnP.device.parentUDN") != null || null == (deviceJSON = this.deviceTreeToJSON(refs[i]))) continue;
                    json.append("devices", (Object)deviceJSON);
                }
            } else if ("serviceDetails".equals(method)) {
                UPnPService service = this.requireService(request);
                SessionObject session = this.getSession(request).subscribe(ControlServlet.require("udn", request), service.getId());
                json = Serializer.serviceToJSON(service, session);
            } else if ("invokeAction".equals(method)) {
                UPnPService service = this.requireService(request);
                UPnPAction action = service.getAction(ControlServlet.require("actionID", request));
                json = ControlServlet.invoke(action, request.getParameterValues("names"), request.getParameterValues("vals"));
            } else {
                throw new ServletException("Invalid action: " + method);
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print(json.toString(2));
        }
        catch (ServletException e) {
            response.setStatus(500);
            response.setContentType("text/plain");
            e.printStackTrace(response.getWriter());
            response.flushBuffer();
        }
        catch (Exception e) {
            response.setStatus(500);
            response.setContentType("text/plain");
            e.printStackTrace(response.getWriter());
            response.flushBuffer();
        }
    }

    private final SessionObject getSession(HttpServletRequest request) {
        String sessionID = request.getSession().getId();
        SessionObject ret = (SessionObject)this.sessions.get(sessionID);
        if (ret == null) {
            ret = new SessionObject(this.bc, sessionID, this.sessions);
            request.getSession().setAttribute("___upnp.session.object", (Object)ret);
        }
        return ret;
    }

    private static final String require(String name, HttpServletRequest request) throws ServletException {
        String value = request.getParameter(name);
        if (value == null) {
            throw new ServletException("missing parameter: " + name);
        }
        return value;
    }

    private final UPnPService requireService(HttpServletRequest request) throws ServletException {
        String deviceUdn = ControlServlet.require("udn", request);
        String serviceUrn = ControlServlet.require("urn", request);
        UPnPDevice device = this.getDevice(deviceUdn);
        return ControlServlet.getService(device, serviceUrn);
    }

    private final JSONObject deviceTreeToJSON(ServiceReference ref) throws JSONException {
        UPnPDevice device = (UPnPDevice)this.tracker.getService(ref);
        if (null == device) {
            return null;
        }
        Object parentUdn = ref.getProperty("UPnP.device.UDN");
        if (parentUdn == null) {
            this.plugin.log(1, "Invalid device, no UDN property specified for " + device);
            return null;
        }
        JSONObject json = Serializer.deviceToJSON(ref, device);
        ServiceReference[] refs = this.tracker.getServiceReferences();
        for (int i = 0; refs != null && i < refs.length; ++i) {
            JSONObject deviceJSON;
            ref = refs[i];
            Object parent = ref.getProperty("UPnP.device.parentUDN");
            Object currentUDN = ref.getProperty("UPnP.device.UDN");
            if (parent == null || currentUDN != null && currentUDN.equals(parent) || !parentUdn.equals(parent) || null == (deviceJSON = this.deviceTreeToJSON(ref))) continue;
            json.append("children", (Object)deviceJSON);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JSONObject invoke(UPnPAction action, String[] names, String[] vals) throws Exception {
        Dictionary out;
        JSONObject json = new JSONObject();
        Hashtable<String, String> inputArgs = null;
        if (names != null && vals != null && names.length > 0 && names.length == vals.length) {
            inputArgs = new Hashtable<String, String>(names.length);
            for (int i = 0; i < names.length; ++i) {
                Object argObj;
                UPnPStateVariable var = action.getStateVariable(names[i]);
                String upnpType = var.getUPnPDataType();
                if ("string".equals(upnpType)) {
                    argObj = vals[i];
                } else if ("char".equals(upnpType)) {
                    argObj = new Character(vals[i].charAt(0));
                } else if ("bin.base64".equals(upnpType)) {
                    argObj = Base64.decodeBase64(vals[i]);
                } else if ("bin.hex".equals(upnpType)) {
                    argObj = Hex.decode(vals[i]);
                } else {
                    Class javaType = var.getJavaDataType();
                    Constructor constructor = javaType.getConstructor(class$java$lang$String == null ? ControlServlet.class$("java.lang.String") : class$java$lang$String);
                    argObj = constructor.newInstance(vals[i]);
                }
                inputArgs.put(names[i], (String)argObj);
            }
        }
        if ((out = action.invoke(inputArgs)) != null && out.size() > 0) {
            Enumeration e = out.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                UPnPStateVariable var = action.getStateVariable(key);
                Object value = out.get(key);
                if (value instanceof Date) {
                    SimpleDateFormat simpleDateFormat = DATA_FORMAT;
                    synchronized (simpleDateFormat) {
                        value = DATA_FORMAT.format((Date)value);
                    }
                } else if (value instanceof byte[]) {
                    value = Hex.encode((byte[])value);
                }
                json.append("output", (Object)new JSONObject().put("name", (Object)key).put("type", (Object)var.getUPnPDataType()).put("value", value));
            }
        }
        return json;
    }

    private final void fillCache() {
        ServiceReference[] refs = this.tracker.getServiceReferences();
        for (int i = 0; i < refs.length; ++i) {
            ServiceReference ref = refs[i];
            Object udn = ref.getProperty("UPnP.device.UDN");
            if (this.icons.containsKey(udn)) continue;
            UPnPDevice device = (UPnPDevice)this.bc.getService(ref);
            UPnPIcon icon = null;
            try {
                UPnPIcon[] _icons = device == null ? null : device.getIcons(null);
                icon = _icons != null && _icons.length > 0 ? _icons[0] : null;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.icons.put(udn, icon);
            this.devices.put(udn, device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UPnPIcon getIcon(String udn) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.fillCache();
            return (UPnPIcon)this.icons.get(udn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UPnPDevice getDevice(String udn) {
        UPnPDevice device;
        Object object = this.cacheLock;
        synchronized (object) {
            this.fillCache();
            device = (UPnPDevice)this.devices.get(udn);
        }
        if (null == device) {
            throw new IllegalArgumentException("Device '" + udn + "' not found!");
        }
        return device;
    }

    private static final UPnPService getService(UPnPDevice device, String urn) {
        UPnPService[] services = device.getServices();
        for (int i = 0; services != null && i < services.length; ++i) {
            if (!services[i].getType().equals(urn)) continue;
            return services[i];
        }
        throw new IllegalArgumentException("Service '" + urn + "' not found!");
    }

    ControlServlet(BundleContext bc, ServiceTracker tracker, WebConsolePlugin plugin) {
        this.bc = bc;
        this.tracker = tracker;
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.icons.clear();
        }
        object = this.sessions;
        synchronized (object) {
            Iterator i = this.sessions.values().iterator();
            while (i.hasNext()) {
                ((SessionObject)i.next()).unsubscribe();
            }
            this.sessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removedService(ServiceReference ref) {
        Object udn = ref.getProperty("UPnP.device.UDN");
        Object object = this.cacheLock;
        synchronized (object) {
            this.icons.remove(udn);
            this.devices.remove(udn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

