/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.rootcause;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.felix.systemready.rootcause.DSComp;
import org.apache.felix.systemready.rootcause.DSRef;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

public class DSRootCause {
    private static final int MAX_RECURSION = 10;
    private ServiceComponentRuntime scr;

    public DSRootCause(ServiceComponentRuntime scr) {
        this.scr = scr;
    }

    public Optional<DSComp> getRootCause(String iface) {
        return this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(desc -> this.offersInterface((ComponentDescriptionDTO)desc, iface)).map(this::getRootCause).findFirst();
    }

    public DSComp getRootCause(ComponentDescriptionDTO desc) {
        return this.getRootCause(desc, 0);
    }

    private DSComp getRootCause(ComponentDescriptionDTO desc, int level) {
        if (level > 10) {
            throw new IllegalStateException("Aborting after because of cyclic references");
        }
        DSComp dsComp = new DSComp();
        dsComp.desc = desc;
        Collection instances = this.scr.getComponentConfigurationDTOs(desc);
        if (instances.isEmpty()) {
            return dsComp;
        }
        for (ComponentConfigurationDTO instance : instances) {
            for (UnsatisfiedReferenceDTO ref : instance.unsatisfiedReferences) {
                ReferenceDTO refdef = this.getReference(desc, ref.name);
                DSRef unresolvedRef = this.createRef(ref, refdef);
                unresolvedRef.candidates = this.getCandidates(ref, refdef, level + 1);
                dsComp.unsatisfied.add(unresolvedRef);
            }
        }
        return dsComp;
    }

    private DSRef createRef(UnsatisfiedReferenceDTO unsatifiedRef, ReferenceDTO refdef) {
        DSRef ref = new DSRef();
        ref.name = unsatifiedRef.name;
        ref.filter = unsatifiedRef.target;
        ref.iface = refdef.interfaceName;
        return ref;
    }

    private List<DSComp> getCandidates(UnsatisfiedReferenceDTO ref, ReferenceDTO refdef, int level) {
        return this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(desc -> this.offersInterface((ComponentDescriptionDTO)desc, refdef.interfaceName)).map(desc -> this.getRootCause((ComponentDescriptionDTO)desc, level)).collect(Collectors.toList());
    }

    private boolean offersInterface(ComponentDescriptionDTO desc, String interfaceName) {
        return Arrays.asList(desc.serviceInterfaces).contains(interfaceName);
    }

    private ReferenceDTO getReference(ComponentDescriptionDTO desc, String name) {
        return Arrays.asList(desc.references).stream().filter(ref -> ref.name.equals(name)).findFirst().get();
    }
}

