/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulation.InnerClassManipulator;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.manipulator.QuotedTokenizer;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.xml.parser.ParseException;
import org.apache.felix.ipojo.xml.parser.SchemaResolver;
import org.apache.felix.ipojo.xml.parser.XMLMetadataParser;
import org.objectweb.asm.ClassReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Pojoization {
    public static final String IPOJO_PACKAGE_VERSION = " 1.2.0";
    private List m_components;
    private Element[] m_metadata = new Element[0];
    private List m_errors = new ArrayList();
    private List m_warnings = new ArrayList();
    private Map m_classes = new HashMap();
    private List m_referredPackages;
    private boolean m_ignoreAnnotations;
    private boolean m_ignoreLocalXSD;

    private void error(String mes) {
        this.m_errors.add(mes);
    }

    public void warn(String mes) {
        this.m_warnings.add(mes);
    }

    public List getErrors() {
        return this.m_errors;
    }

    public void setAnnotationProcessing() {
        this.m_ignoreAnnotations = false;
    }

    public void setUseLocalXSD() {
        this.m_ignoreLocalXSD = false;
    }

    public void pojoization(File in, File out, InputStream metadata) {
        JarFile inputJar;
        this.m_metadata = this.parseXMLMetadata(metadata);
        if (this.m_metadata == null) {
            return;
        }
        try {
            inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.m_components = this.getDeclaredComponents(this.m_metadata);
        this.manipulation(inputJar, out);
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    public void pojoization(File in, File out, File metadataFile) {
        JarFile inputJar;
        if (metadataFile != null) {
            try {
                InputStream stream = null;
                URL url = metadataFile.toURL();
                if (url == null) {
                    this.warn("Cannot find the metadata file : " + metadataFile.getAbsolutePath());
                    this.m_metadata = new Element[0];
                } else {
                    stream = url.openStream();
                    this.m_metadata = this.parseXMLMetadata(stream);
                }
            }
            catch (MalformedURLException e) {
                this.error("Cannot open the metadata input stream from " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
                this.m_metadata = null;
            }
            catch (IOException e) {
                this.error("Cannot open the metadata input stream: " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
                this.m_metadata = null;
            }
            if (this.m_metadata == null) {
                return;
            }
        }
        try {
            inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.m_components = this.getDeclaredComponents(this.m_metadata);
        this.manipulation(inputJar, out);
        for (int i = 0; i < this.m_components.size(); ++i) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (ci.m_isManipulated) continue;
            this.error("The component " + ci.m_classname + " is declared but not in the bundle");
        }
    }

    private void computeAnnotations(byte[] inC) {
        ClassReader cr = new ClassReader(inC);
        MetadataCollector xml = new MetadataCollector();
        cr.accept(xml, 0);
        if (xml.isAnnotated()) {
            boolean toskip = false;
            for (int i = 0; !toskip && i < this.m_metadata.length; ++i) {
                if (!this.m_metadata[i].containsAttribute("name") || !this.m_metadata[i].getAttribute("name").equalsIgnoreCase(xml.getElem().getAttribute("name"))) continue;
                toskip = true;
                this.warn("The component " + xml.getElem().getAttribute("name") + " is overriden by the metadata file");
            }
            if (!toskip) {
                if (this.m_metadata != null && this.m_metadata.length > 0) {
                    Element[] newElementsList = new Element[this.m_metadata.length + 1];
                    System.arraycopy(this.m_metadata, 0, newElementsList, 0, this.m_metadata.length);
                    newElementsList[this.m_metadata.length] = xml.getElem();
                    this.m_metadata = newElementsList;
                } else {
                    this.m_metadata = new Element[]{xml.getElem()};
                }
                String name = this.m_metadata[this.m_metadata.length - 1].getAttribute("classname");
                name = name.replace('.', '/');
                name = name + ".class";
                this.m_components.add(new ComponentInfo(name, this.m_metadata[this.m_metadata.length - 1]));
            }
        }
    }

    private void manipulation(JarFile inputJar, File out) {
        this.manipulateComponents(inputJar);
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest(inputJar);
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(out);
            jos = new JarOutputStream((OutputStream)fos, mf);
        }
        catch (FileNotFoundException e1) {
            this.error("Cannot manipulate the Jar file : the output file " + out.getAbsolutePath() + " is not found");
            return;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : cannot access to " + out.getAbsolutePath());
            return;
        }
        try {
            Enumeration<JarEntry> entries = inputJar.entries();
            while (entries.hasMoreElements()) {
                int c;
                JarEntry curEntry = entries.nextElement();
                if (this.m_classes.containsKey(curEntry.getName())) {
                    int c2;
                    JarEntry je = new JarEntry(curEntry.getName());
                    byte[] outClazz = (byte[])this.m_classes.get(curEntry.getName());
                    if (outClazz.length != 0) {
                        jos.putNextEntry(je);
                        jos.write(outClazz);
                        jos.closeEntry();
                        continue;
                    }
                    jos.putNextEntry(curEntry);
                    InputStream currIn = inputJar.getInputStream(curEntry);
                    int i = 0;
                    while ((c2 = currIn.read()) >= 0) {
                        jos.write(c2);
                        ++i;
                    }
                    currIn.close();
                    jos.closeEntry();
                    continue;
                }
                if (curEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                jos.putNextEntry(curEntry);
                InputStream currIn = inputJar.getInputStream(curEntry);
                int i = 0;
                while ((c = currIn.read()) >= 0) {
                    jos.write(c);
                    ++i;
                }
                currIn.close();
                jos.closeEntry();
            }
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : " + e.getMessage());
            return;
        }
        try {
            inputJar.close();
            jos.close();
            fos.close();
            jos = null;
            fos = null;
        }
        catch (IOException e) {
            this.error("Cannot close the new Jar file : " + e.getMessage());
            return;
        }
    }

    private void manipulateComponents(JarFile inputJar) {
        Enumeration<JarEntry> entries = inputJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry curEntry = entries.nextElement();
            if (!curEntry.getName().endsWith(".class")) continue;
            try {
                int c;
                InputStream currIn = inputJar.getInputStream(curEntry);
                byte[] in = new byte[]{};
                while ((c = currIn.read()) >= 0) {
                    byte[] in2 = new byte[in.length + 1];
                    System.arraycopy(in, 0, in2, 0, in.length);
                    in2[in.length] = (byte)c;
                    in = in2;
                }
                currIn.close();
                if (!this.m_ignoreAnnotations) {
                    this.computeAnnotations(in);
                }
                for (int i = 0; i < this.m_components.size(); ++i) {
                    ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
                    if (!ci.m_classname.equals(curEntry.getName())) continue;
                    byte[] outClazz = this.manipulateComponent(in, curEntry, ci);
                    this.m_classes.put(curEntry.getName(), outClazz);
                    if (ci.m_inners.isEmpty()) continue;
                    for (int k = 0; k < ci.m_inners.size(); ++k) {
                        JarEntry inner = inputJar.getJarEntry((String)ci.m_inners.get(k) + ".class");
                        this.manipulateInnerClass(inputJar, inner, (String)ci.m_inners.get(k), ci);
                    }
                }
            }
            catch (IOException e) {
                this.error("Cannot read the class : " + curEntry.getName());
                return;
            }
        }
    }

    private void manipulateInnerClass(JarFile inputJar, JarEntry je, String innerClassName, ComponentInfo ci) throws IOException {
        int c;
        InputStream currIn = inputJar.getInputStream(je);
        byte[] in = new byte[]{};
        while ((c = currIn.read()) >= 0) {
            byte[] in2 = new byte[in.length + 1];
            System.arraycopy(in, 0, in2, 0, in.length);
            in2[in.length] = (byte)c;
            in = in2;
        }
        InnerClassManipulator man = new InnerClassManipulator(ci.m_classname.substring(0, ci.m_classname.length() - 6), ci.m_fields);
        byte[] out = man.manipulate(in);
        this.m_classes.put(je.getName(), out);
    }

    private Manifest doManifest(JarFile initial) {
        Manifest mf = null;
        try {
            mf = initial.getManifest();
        }
        catch (IOException e) {
            this.error("Cannot get the manifest from the input bundle : " + e.getMessage());
            return null;
        }
        Attributes att = mf.getMainAttributes();
        this.setImports(att);
        this.setPOJOMetadata(att);
        this.setCreatedBy(att);
        return mf;
    }

    private byte[] manipulateComponent(byte[] in, JarEntry je, ComponentInfo ci) {
        Manipulator man = new Manipulator();
        try {
            byte[] out = man.manipulate(in);
            ci.detectMissingFields(man.getFields());
            ci.m_componentMetadata.addElement(man.getManipulationMetadata());
            ci.m_isManipulated = true;
            ci.m_inners = man.getInnerClasses();
            ci.m_fields = man.getFields().keySet();
            return out;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the class " + je.getName() + " : " + e.getMessage());
            return null;
        }
    }

    private List getDeclaredComponents(Element[] meta) {
        ArrayList<ComponentInfo> componentClazzes = new ArrayList<ComponentInfo>();
        for (int i = 0; i < meta.length; ++i) {
            String name = meta[i].getAttribute("classname");
            if (name == null) continue;
            name = name.replace('.', '/');
            name = name + ".class";
            componentClazzes.add(new ComponentInfo(name, meta[i]));
        }
        return componentClazzes;
    }

    private void setCreatedBy(Attributes att) {
        String prev = att.getValue("Created-By");
        att.putValue("Created-By", prev + " & iPOJO");
    }

    private void setImports(Attributes att) {
        TreeMap<String, String> verCM;
        Map imports = this.parseHeader(att.getValue("Import-Package"));
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("version", IPOJO_PACKAGE_VERSION);
        if (!imports.containsKey("org.apache.felix.ipojo")) {
            imports.put("org.apache.felix.ipojo", ver);
        }
        if (!imports.containsKey("org.apache.felix.ipojo.architecture")) {
            imports.put("org.apache.felix.ipojo.architecture", ver);
        }
        if (!imports.containsKey("org.osgi.service.cm")) {
            verCM = new TreeMap<String, String>();
            verCM.put("version", "1.2");
            imports.put("org.osgi.service.cm", verCM);
        }
        if (!imports.containsKey("org.osgi.service.log")) {
            verCM = new TreeMap();
            verCM.put("version", "1.3");
            imports.put("org.osgi.service.log", verCM);
        }
        for (int i = 0; i < this.m_referredPackages.size(); ++i) {
            String pack = (String)this.m_referredPackages.get(i);
            imports.put(pack, new TreeMap());
        }
        att.putValue("Import-Package", this.printClauses(imports, "resolution:"));
    }

    private void setPOJOMetadata(Attributes att) {
        StringBuffer meta = new StringBuffer();
        for (int i = 0; i < this.m_metadata.length; ++i) {
            meta.append(this.buildManifestMetadata(this.m_metadata[i], new StringBuffer()));
        }
        if (meta.length() != 0) {
            att.putValue("iPOJO-Components", meta.toString());
        }
    }

    public Map parseHeader(String value) {
        char del;
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        HashMap result = new HashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(qt.nextToken());
            del = qt.getSeparator();
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute) {
                        throw new IllegalArgumentException("Header contains name field after attribute or directive: " + adname + " from " + value);
                    }
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                result.put(i.next(), clause);
            }
        } while (del == ',');
        return result;
    }

    public String printClauses(Map exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = exports.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            sb.append(del);
            sb.append(name);
            Iterator j = map.entrySet().iterator();
            while (j.hasNext()) {
                boolean dirty;
                Map.Entry entry2 = j.next();
                String key = (String)entry2.getKey();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = (String)entry2.getValue();
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ", ";
        }
        return sb.toString();
    }

    private Element[] parseXMLMetadata(InputStream stream) {
        Element[] meta = null;
        try {
            XMLReader parser = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            XMLMetadataParser handler = new XMLMetadataParser();
            parser.setContentHandler(handler);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(handler);
            if (!this.m_ignoreLocalXSD) {
                parser.setEntityResolver(new SchemaResolver());
            }
            InputSource is = new InputSource(stream);
            parser.parse(is);
            meta = handler.getMetadata();
            stream.close();
        }
        catch (IOException e) {
            this.error("Cannot open the metadata input stream: " + e.getMessage());
            return null;
        }
        catch (ParseException e) {
            this.error("Parsing error when parsing the XML file: " + e.getMessage());
            return null;
        }
        catch (SAXParseException e) {
            this.error("Error during metadata parsing at line " + e.getLineNumber() + " : " + e.getMessage());
            return null;
        }
        catch (SAXException e) {
            this.error("Parsing error when parsing (Sax Error) the XML file: " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            this.error("Cannot instantiate the SAX parser for the XML file: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            this.error("Cannot instantiate  the SAX parser (IllegalAccess) to the XML file: " + e.getMessage());
            return null;
        }
        catch (ClassNotFoundException e) {
            this.error("Cannot load the SAX Parser : " + e.getMessage());
            return null;
        }
        if (meta == null || meta.length == 0) {
            this.warn("Neither component types, nor instances in the metadata");
        }
        return meta;
    }

    private List getReferredPackages() {
        ArrayList<String> referred = new ArrayList<String>();
        for (int i = 0; i < this.m_metadata.length; ++i) {
            Element[] elems = this.m_metadata[i].getElements();
            for (int j = 0; j < elems.length; ++j) {
                int last;
                String att = elems[j].getAttribute("specification");
                if (att == null || (last = att.lastIndexOf(46)) == -1) continue;
                referred.add(att.substring(0, last));
            }
        }
        return referred;
    }

    private StringBuffer buildManifestMetadata(Element element, StringBuffer actual) {
        StringBuffer result = new StringBuffer();
        if (element.getNameSpace() == null) {
            result.append(actual + element.getName() + " { ");
        } else {
            result.append(actual + element.getNameSpace() + ":" + element.getName() + " { ");
        }
        Attribute[] atts = element.getAttributes();
        for (int i = 0; i < atts.length; ++i) {
            Attribute current = atts[i];
            if (current.getNameSpace() == null) {
                result.append("$" + current.getName() + "=\"" + current.getValue() + "\" ");
                continue;
            }
            result.append("$" + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\" ");
        }
        Element[] elems = element.getElements();
        for (int i = 0; i < elems.length; ++i) {
            result = this.buildManifestMetadata(elems[i], result);
        }
        result.append("}");
        return result;
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    private class ComponentInfo {
        Element m_componentMetadata;
        String m_classname;
        boolean m_isManipulated;
        List m_inners;
        Set m_fields;

        ComponentInfo(String cn, Element met) {
            this.m_classname = cn;
            this.m_componentMetadata = met;
            this.m_isManipulated = false;
        }

        void detectMissingFields(Map fields) {
            ArrayList list = new ArrayList();
            this.computeReferredFields(list, this.m_componentMetadata);
            for (int i = 0; i < list.size(); ++i) {
                if (fields.containsKey(list.get(i))) continue;
                Pojoization.this.error("The field " + list.get(i) + " is referenced in the " + "metadata but does not exist in the " + this.m_classname + " class");
            }
        }

        private void computeReferredFields(List list, Element metadata) {
            String field = metadata.getAttribute("field");
            if (field != null && !list.contains(field)) {
                list.add(field);
            }
            for (int i = 0; i < metadata.getElements().length; ++i) {
                this.computeReferredFields(list, metadata.getElements()[i]);
            }
        }
    }
}

