/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation.annotations;

import org.apache.felix.ipojo.manipulation.annotations.CustomAnnotationVisitor;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class FieldCollector
extends EmptyVisitor
implements FieldVisitor {
    private MetadataCollector m_collector;
    private String m_field;

    public FieldCollector(String fieldName, MetadataCollector collector) {
        this.m_collector = collector;
        this.m_field = fieldName;
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Requires;")) {
            return new RequiresAnnotationParser(this.m_field);
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Controller;")) {
            Element elem = new Element("controller", "");
            elem.addAttribute(new Attribute("field", this.m_field));
            this.m_collector.getElements().put(elem, null);
            return null;
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/ServiceProperty;")) {
            if (!this.m_collector.getIds().containsKey("provides")) {
                System.err.println("The component does not provide services, skip ServiceProperty for " + this.m_field);
                return null;
            }
            Element parent = (Element)this.m_collector.getIds().get("provides");
            return new PropertyAnnotationParser(this.m_field, parent);
        }
        if (arg0.equals("Lorg/apache/felix/ipojo/annotations/Property;")) {
            Element parent = null;
            if (!this.m_collector.getIds().containsKey("properties")) {
                parent = new Element("Properties", "");
                this.m_collector.getIds().put("properties", parent);
                this.m_collector.getElements().put(parent, null);
            } else {
                parent = (Element)this.m_collector.getIds().get("properties");
            }
            return new PropertyAnnotationParser(this.m_field, parent);
        }
        if (CustomAnnotationVisitor.isCustomAnnotation(arg0)) {
            Element elem = CustomAnnotationVisitor.buildElement(arg0);
            elem.addAttribute(new Attribute("field", this.m_field));
            return new CustomAnnotationVisitor(elem, this.m_collector, true, false);
        }
        return null;
    }

    private static final class PropertyAnnotationParser
    extends EmptyVisitor
    implements AnnotationVisitor {
        private Element m_parent;
        private String m_field;
        private String m_name;
        private String m_value;
        private String m_mandatory;

        private PropertyAnnotationParser(String field, Element parent) {
            this.m_parent = parent;
            this.m_field = field;
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("name")) {
                this.m_name = arg1.toString();
                return;
            }
            if (arg0.equals("value")) {
                this.m_value = arg1.toString();
                return;
            }
            if (arg0.equals("mandatory")) {
                this.m_mandatory = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            if (this.m_name == null) {
                this.m_name = this.m_field;
            }
            Element[] props = this.m_parent.getElements("Property");
            Element prop = null;
            for (int i = 0; prop == null && props != null && i < props.length; ++i) {
                String name = props[i].getAttribute("name");
                if (name == null || !name.equals(this.m_name)) continue;
                prop = props[i];
            }
            if (prop == null) {
                prop = new Element("property", "");
                this.m_parent.addElement(prop);
                if (this.m_name != null) {
                    prop.addAttribute(new Attribute("name", this.m_name));
                }
            }
            prop.addAttribute(new Attribute("field", this.m_field));
            if (this.m_value != null) {
                prop.addAttribute(new Attribute("value", this.m_value));
            }
            if (this.m_mandatory != null) {
                prop.addAttribute(new Attribute("mandatory", this.m_mandatory));
            }
        }
    }

    private final class RequiresAnnotationParser
    extends EmptyVisitor
    implements AnnotationVisitor {
        private String m_field;
        private String m_filter;
        private String m_optional;
        private String m_specification;
        private String m_id;
        private String m_policy;
        private String m_defaultImplementation;
        private String m_nullable;
        private String m_comparator;
        private String m_from;

        private RequiresAnnotationParser(String name) {
            this.m_field = name;
        }

        public void visit(String arg0, Object arg1) {
            if (arg0.equals("filter")) {
                this.m_filter = arg1.toString();
                return;
            }
            if (arg0.equals("optional")) {
                this.m_optional = arg1.toString();
                return;
            }
            if (arg0.equals("nullable")) {
                this.m_nullable = arg1.toString();
                return;
            }
            if (arg0.equals("policy")) {
                this.m_policy = arg1.toString();
                return;
            }
            if (arg0.equals("defaultimplementation")) {
                Type type = Type.getType(arg1.toString());
                this.m_defaultImplementation = type.getClassName();
                return;
            }
            if (arg0.equals("specification")) {
                this.m_specification = arg1.toString();
                return;
            }
            if (arg0.equals("id")) {
                this.m_id = arg1.toString();
                return;
            }
            if (arg0.equals("comparator")) {
                Type type = Type.getType(arg1.toString());
                this.m_comparator = type.getClassName();
                return;
            }
            if (arg0.equals("from")) {
                this.m_from = arg1.toString();
                return;
            }
        }

        public void visitEnd() {
            Element req = null;
            req = this.m_id == null ? (Element)FieldCollector.this.m_collector.getIds().get(this.m_field) : (Element)FieldCollector.this.m_collector.getIds().get(this.m_id);
            if (req == null) {
                req = new Element("requires", "");
            }
            req.addAttribute(new Attribute("field", this.m_field));
            if (this.m_specification != null) {
                req.addAttribute(new Attribute("specification", this.m_specification));
            }
            if (this.m_filter != null) {
                req.addAttribute(new Attribute("filter", this.m_filter));
            }
            if (this.m_optional != null) {
                req.addAttribute(new Attribute("optional", this.m_optional));
            }
            if (this.m_nullable != null) {
                req.addAttribute(new Attribute("nullable", this.m_nullable));
            }
            if (this.m_defaultImplementation != null) {
                req.addAttribute(new Attribute("default-implementation", this.m_defaultImplementation));
            }
            if (this.m_policy != null) {
                req.addAttribute(new Attribute("policy", this.m_policy));
            }
            if (this.m_id != null) {
                req.addAttribute(new Attribute("id", this.m_id));
            }
            if (this.m_comparator != null) {
                req.addAttribute(new Attribute("comparator", this.m_comparator));
            }
            if (this.m_from != null) {
                req.addAttribute(new Attribute("from", this.m_from));
            }
            if (this.m_id != null) {
                FieldCollector.this.m_collector.getIds().put(this.m_id, req);
            } else {
                FieldCollector.this.m_collector.getIds().put(this.m_field, req);
            }
            FieldCollector.this.m_collector.getElements().put(req, null);
        }
    }
}

