/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.publisher;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.ipojo.handlers.event.publisher.EventAdminPublisherHandler;
import org.apache.felix.ipojo.handlers.event.publisher.Publisher;
import org.osgi.service.event.Event;

public class PublisherImpl
implements Publisher {
    public static final String INSTANCE_NAME_PROPERTY = "publisher.instance.name";
    private EventAdminPublisherHandler m_handler;
    private final String[] m_topics;
    private final boolean m_synchronous;
    private final String m_dataKey;
    private final String m_instanceName;

    public PublisherImpl(EventAdminPublisherHandler handler, String[] topics, boolean synchronous, String dataKey, String instanceName) {
        this.m_handler = handler;
        this.m_topics = topics;
        this.m_synchronous = synchronous;
        this.m_dataKey = dataKey;
        this.m_instanceName = instanceName;
    }

    public void send(Dictionary content) {
        content.put(INSTANCE_NAME_PROPERTY, this.m_instanceName);
        for (int i = 0; i < this.m_topics.length; ++i) {
            Event e = new Event(this.m_topics[i], content);
            if (!this.m_synchronous) {
                this.m_handler.getEventAdminService().postEvent(e);
                continue;
            }
            this.m_handler.getEventAdminService().sendEvent(e);
        }
    }

    public void sendData(Object object) {
        Hashtable<String, Object> content = new Hashtable<String, Object>();
        ((Dictionary)content).put(this.m_dataKey, object);
        this.send(content);
    }
}

