/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.subscriber;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.event.EventUtil;
import org.apache.felix.ipojo.handlers.event.subscriber.EventAdminSubscriberMetadata;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Callback;
import org.osgi.framework.Filter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventAdminSubscriberHandler
extends PrimitiveHandler
implements EventHandler {
    public static final String NAMESPACE = "org.apache.felix.ipojo.handlers.event";
    public static final String TOPICS_PROPERTY = "event.topics";
    public static final String FILTER_PROPERTY = "event.filter";
    private static final String LOG_PREFIX = "EVENT ADMIN SUBSCRIBER HANDLER : ";
    private InstanceManager m_manager;
    private Map m_subscribersByName = new HashMap();
    private Map m_callbacksByName = new Hashtable();
    private String[] m_topics;
    private boolean m_isListening;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$org$osgi$service$event$Event;

    public void initializeComponentFactory(ComponentTypeDescription cd, Element metadata) throws ConfigurationException {
        Properties dict = new Properties();
        cd.addProperty(new PropertyDescription(TOPICS_PROPERTY, (class$java$util$Dictionary == null ? (class$java$util$Dictionary = EventAdminSubscriberHandler.class$("java.util.Dictionary")) : class$java$util$Dictionary).getName(), ((Object)dict).toString()));
        dict = new Properties();
        cd.addProperty(new PropertyDescription(FILTER_PROPERTY, (class$java$util$Dictionary == null ? (class$java$util$Dictionary = EventAdminSubscriberHandler.class$("java.util.Dictionary")) : class$java$util$Dictionary).getName(), ((Object)dict).toString()));
        Element[] subscribers = metadata.getElements("subscriber", NAMESPACE);
        if (subscribers != null) {
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> callbackSet = new HashSet<String>();
            for (int i = 0; i < subscribers.length; ++i) {
                EventAdminSubscriberMetadata subscriberMetadata = new EventAdminSubscriberMetadata(this.getFactory().getBundleContext(), subscribers[i]);
                String name = subscriberMetadata.getName();
                this.info("EVENT ADMIN SUBSCRIBER HANDLER : Checking subscriber " + name);
                PojoMetadata pojoMetadata = this.getPojoMetadata();
                String callbackType = subscriberMetadata.getDataKey() == null ? (class$org$osgi$service$event$Event == null ? EventAdminSubscriberHandler.class$("org.osgi.service.event.Event") : class$org$osgi$service$event$Event).getName() : subscriberMetadata.getDataType().getName();
                MethodMetadata methodMetadata = pojoMetadata.getMethod(subscriberMetadata.getCallback(), new String[]{callbackType});
                String callbackSignature = subscriberMetadata.getCallback() + "(" + callbackType + ")";
                if (methodMetadata == null) {
                    throw new ConfigurationException("Cannot find callback method " + callbackSignature);
                }
                if (callbackSet.contains(callbackSignature)) {
                    this.warn("The callback method is already used by another subscriber : " + callbackSignature);
                } else {
                    callbackSet.add(callbackSignature);
                }
                if (nameSet.contains(name)) {
                    throw new ConfigurationException("A subscriber with the same name already exists : " + name);
                }
                nameSet.add(name);
            }
        } else {
            this.info("EVENT ADMIN SUBSCRIBER HANDLER : No subscriber to check");
        }
    }

    public void configure(Element metadata, Dictionary conf) throws ConfigurationException {
        this.m_manager = this.getInstanceManager();
        Dictionary instanceTopics = (Dictionary)conf.get(TOPICS_PROPERTY);
        Dictionary instanceFilter = (Dictionary)conf.get(FILTER_PROPERTY);
        Element[] subscribers = metadata.getElements("subscriber", NAMESPACE);
        TreeSet<String> topics = new TreeSet<String>();
        if (subscribers != null) {
            int i;
            for (i = 0; i < subscribers.length; ++i) {
                String filterString;
                String topicsString;
                EventAdminSubscriberMetadata subscriberMetadata = new EventAdminSubscriberMetadata(this.m_manager.getContext(), subscribers[i]);
                String name = subscriberMetadata.getName();
                this.info("EVENT ADMIN SUBSCRIBER HANDLER : Configuring subscriber " + name);
                String string = topicsString = instanceTopics != null ? (String)instanceTopics.get(name) : null;
                if (topicsString != null) {
                    subscriberMetadata.setTopics(topicsString);
                }
                String string2 = filterString = instanceFilter != null ? (String)instanceFilter.get(name) : null;
                if (filterString != null) {
                    subscriberMetadata.setFilter(filterString);
                }
                subscriberMetadata.check();
                String[] subscriberTopics = subscriberMetadata.getTopics();
                for (int j = 0; j < subscriberTopics.length; ++j) {
                    topics.add(subscriberTopics[j]);
                }
                PojoMetadata pojoMetadata = this.getPojoMetadata();
                String callbackType = subscriberMetadata.getDataKey() == null ? (class$org$osgi$service$event$Event == null ? EventAdminSubscriberHandler.class$("org.osgi.service.event.Event") : class$org$osgi$service$event$Event).getName() : subscriberMetadata.getDataType().getName();
                MethodMetadata methodMetadata = pojoMetadata.getMethod(subscriberMetadata.getCallback(), new String[]{callbackType});
                Callback callback = new Callback(methodMetadata, this.m_manager);
                this.m_callbacksByName.put(name, callback);
                this.m_subscribersByName.put(name, subscriberMetadata);
            }
            this.m_topics = new String[topics.size()];
            i = 0;
            Iterator iterator = topics.iterator();
            while (iterator.hasNext()) {
                String tmp = (String)iterator.next();
                this.m_topics[i++] = tmp;
            }
        } else {
            this.info("EVENT ADMIN SUBSCRIBER HANDLER : No subscriber to configure");
        }
    }

    public synchronized void start() {
        this.m_isListening = true;
    }

    public synchronized void stop() {
        this.m_isListening = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event) {
        String topic = event.getTopic();
        Collection subscribers = this.m_subscribersByName.values();
        Iterator i = subscribers.iterator();
        while (i.hasNext()) {
            EventAdminSubscriberMetadata subscriberMetadata = (EventAdminSubscriberMetadata)i.next();
            EventAdminSubscriberHandler eventAdminSubscriberHandler = this;
            synchronized (eventAdminSubscriberHandler) {
                Filter filter = subscriberMetadata.getFilter();
                if (EventUtil.matches(topic, subscriberMetadata.getTopics()) && (filter == null || event.matches(filter))) {
                    String name = subscriberMetadata.getName();
                    String dataKey = subscriberMetadata.getDataKey();
                    Callback callback = (Callback)this.m_callbacksByName.get(name);
                    try {
                        if (dataKey == null) {
                            Event event2 = event;
                        } else {
                            Class<?> dataClazz;
                            boolean dataKeyPresent = false;
                            String[] properties = event.getPropertyNames();
                            for (int j = 0; j < properties.length && !dataKeyPresent; ++j) {
                                if (!dataKey.equals(properties[j])) continue;
                                dataKeyPresent = true;
                            }
                            if (!dataKeyPresent) throw new NoSuchFieldException(dataKey);
                            Object data = event.getProperty(dataKey);
                            Class dataType = subscriberMetadata.getDataType();
                            if (!dataType.isAssignableFrom(dataClazz = data.getClass())) throw new ClassCastException("Cannot convert " + dataClazz.getName() + " to " + dataType.getName());
                            Object object = data;
                        }
                        if (this.m_isListening) {
                            void var11_11;
                            callback.call(new Object[]{var11_11});
                        }
                    }
                    catch (ClassCastException e) {
                        this.warn("EVENT ADMIN SUBSCRIBER HANDLER : Ignoring data event : Bad data type", e);
                    }
                    catch (NoSuchFieldException e) {
                        this.warn("EVENT ADMIN SUBSCRIBER HANDLER : Ignoring data event : No data", e);
                    }
                    catch (Exception e) {
                        this.error("EVENT ADMIN SUBSCRIBER HANDLER : Unexpected exception when calling callback", e);
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

