/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.publisher;

import java.util.Hashtable;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.osgi.service.event.Event;

class EventAdminPublisherMetadata {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String FIELD_ATTRIBUTE = "field";
    public static final String TOPICS_ATTRIBUTE = "topics";
    public static final String SYNCHRONOUS_ATTRIBUTE = "synchronous";
    public static final String DATA_KEY_ATTRIBUTE = "data-key";
    public static final String DEFAULT_DATA_KEY_VALUE = "user.data";
    public static final boolean DEFAULT_SYNCHRONOUS_VALUE = false;
    private final String m_name;
    private final String m_field;
    private String[] m_topics;
    private final boolean m_synchronous;
    private final String m_dataKey;

    public EventAdminPublisherMetadata(Element publisher) throws ConfigurationException {
        if (!publisher.containsAttribute(NAME_ATTRIBUTE)) {
            throw new ConfigurationException("Missing required attribute in component configuration : name");
        }
        this.m_name = publisher.getAttribute(NAME_ATTRIBUTE);
        if (!publisher.containsAttribute(FIELD_ATTRIBUTE)) {
            throw new ConfigurationException("Missing required attribute in component configuration : field");
        }
        this.m_field = publisher.getAttribute(FIELD_ATTRIBUTE);
        if (publisher.containsAttribute(TOPICS_ATTRIBUTE)) {
            this.m_topics = ParseUtils.split((String)publisher.getAttribute(TOPICS_ATTRIBUTE), (String)",");
            Hashtable empty = new Hashtable();
            for (int i = 0; i < this.m_topics.length; ++i) {
                String topic = this.m_topics[i];
                try {
                    new Event(topic, empty);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Malformed topic : " + topic);
                }
            }
        } else {
            this.m_topics = null;
        }
        this.m_synchronous = publisher.containsAttribute(SYNCHRONOUS_ATTRIBUTE) ? "true".equalsIgnoreCase(publisher.getAttribute(SYNCHRONOUS_ATTRIBUTE)) : false;
        this.m_dataKey = publisher.containsAttribute(DATA_KEY_ATTRIBUTE) ? publisher.getAttribute(DATA_KEY_ATTRIBUTE) : DEFAULT_DATA_KEY_VALUE;
    }

    public void setTopics(String topicsString) throws ConfigurationException {
        this.m_topics = ParseUtils.split((String)topicsString, (String)",");
        Hashtable empty = new Hashtable();
        for (int i = 0; i < this.m_topics.length; ++i) {
            String topic = this.m_topics[i];
            try {
                new Event(topic, empty);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Malformed topic : " + topic);
            }
        }
    }

    public void check() throws ConfigurationException {
        if (this.m_topics == null || this.m_topics.length == 0) {
            throw new ConfigurationException("Missing required attribute in component or instance configuration : topics");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getField() {
        return this.m_field;
    }

    public String[] getTopics() {
        return this.m_topics;
    }

    public boolean isSynchronous() {
        return this.m_synchronous;
    }

    public String getDataKey() {
        return this.m_dataKey;
    }
}

