/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.subscriber;

import java.util.Hashtable;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.event.Event;

class EventAdminSubscriberMetadata {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String CALLBACK_ATTRIBUTE = "callback";
    public static final String TOPICS_ATTRIBUTE = "topics";
    public static final String DATA_KEY_ATTRIBUTE = "data-key";
    public static final String DATA_TYPE_ATTRIBUTE = "data-type";
    public static final String FILTER_ATTRIBUTE = "filter";
    public static final Class DEFAULT_DATA_TYPE_VALUE = class$java$lang$Object == null ? (class$java$lang$Object = EventAdminSubscriberMetadata.class$("java.lang.Object")) : class$java$lang$Object;
    private final String m_name;
    private final String m_callback;
    private String[] m_topics;
    private final String m_dataKey;
    private final Class m_dataType;
    private Filter m_filter;
    private final BundleContext m_bundleContext;
    static /* synthetic */ Class class$java$lang$Object;

    public EventAdminSubscriberMetadata(BundleContext bundleContext, Element subscriber) throws ConfigurationException {
        this.m_bundleContext = bundleContext;
        if (!subscriber.containsAttribute(NAME_ATTRIBUTE)) {
            throw new ConfigurationException("Missing required attribute in component configuration : name");
        }
        this.m_name = subscriber.getAttribute(NAME_ATTRIBUTE);
        if (!subscriber.containsAttribute(CALLBACK_ATTRIBUTE)) {
            throw new ConfigurationException("Missing required attribute in component configuration : callback");
        }
        this.m_callback = subscriber.getAttribute(CALLBACK_ATTRIBUTE);
        if (subscriber.containsAttribute(TOPICS_ATTRIBUTE)) {
            this.m_topics = ParseUtils.split((String)subscriber.getAttribute(TOPICS_ATTRIBUTE), (String)",");
            Hashtable empty = new Hashtable();
            for (int i = 0; i < this.m_topics.length; ++i) {
                String topic = this.m_topics[i];
                try {
                    new Event(topic, empty);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Malformed topic : " + topic);
                }
            }
        } else {
            this.m_topics = null;
        }
        this.m_dataKey = subscriber.getAttribute(DATA_KEY_ATTRIBUTE);
        if (subscriber.containsAttribute(DATA_TYPE_ATTRIBUTE)) {
            Class type;
            String typeName = subscriber.getAttribute(DATA_TYPE_ATTRIBUTE);
            try {
                type = this.m_bundleContext.getBundle().loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Data type class not found : " + typeName);
            }
            this.m_dataType = type;
        } else {
            this.m_dataType = DEFAULT_DATA_TYPE_VALUE;
        }
        if (subscriber.containsAttribute(FILTER_ATTRIBUTE)) {
            try {
                this.m_filter = this.m_bundleContext.createFilter(subscriber.getAttribute(FILTER_ATTRIBUTE));
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("Invalid filter syntax");
            }
        }
    }

    public void setTopics(String topicsString) throws ConfigurationException {
        this.m_topics = ParseUtils.split((String)topicsString, (String)",");
        Hashtable empty = new Hashtable();
        for (int i = 0; i < this.m_topics.length; ++i) {
            String topic = this.m_topics[i];
            try {
                new Event(topic, empty);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Malformed topic : " + topic);
            }
        }
    }

    public void setFilter(String filterString) throws ConfigurationException {
        try {
            this.m_filter = this.m_bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new ConfigurationException("Invalid filter syntax");
        }
    }

    public void check() throws ConfigurationException {
        if (this.m_topics == null || this.m_topics.length == 0) {
            throw new ConfigurationException("Missing required attribute in component or instance configuration : topics");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String[] getTopics() {
        return this.m_topics;
    }

    public String getCallback() {
        return this.m_callback;
    }

    public String getDataKey() {
        return this.m_dataKey;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

