/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartCompliance;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.util.StringUtil;

public class ServletMultiPartFormData {
    public static CompletableFuture<Parts> from(ServletRequest servletRequest) {
        return ServletMultiPartFormData.from(servletRequest, servletRequest.getContentType());
    }

    public static CompletableFuture<Parts> from(ServletRequest servletRequest, String contentType) {
        CompletionStage futureServletParts = (CompletableFuture)servletRequest.getAttribute(ServletMultiPartFormData.class.getName());
        if (futureServletParts == null) {
            MultipartConfigElement config = (MultipartConfigElement)servletRequest.getAttribute("org.eclipse.jetty.multipartConfig");
            if (config == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No multipart configuration element"));
            }
            if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.getValueParameters(contentType, null))) {
                return CompletableFuture.failedFuture(new IllegalStateException("Not multipart Content-Type"));
            }
            String boundary = MultiPart.extractBoundary(servletRequest.getContentType());
            if (boundary == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No multipart boundary parameter in Content-Type"));
            }
            ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(servletRequest);
            if (servletContextRequest == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No core request"));
            }
            File filesDirectory = StringUtil.isBlank(config.getLocation()) ? servletContextRequest.getContext().getTempDirectory() : new File(config.getLocation());
            HttpChannel httpChannel = HttpChannel.from(servletContextRequest);
            ComplianceViolation.Listener complianceViolationListener = httpChannel.getComplianceViolationListener();
            MultiPartCompliance compliance = servletContextRequest.getConnectionMetaData().getHttpConfiguration().getMultiPartCompliance();
            CompletableFuture<MultiPartFormData.Parts> futureFormData = MultiPartFormData.from(servletContextRequest, compliance, complianceViolationListener, boundary, parser -> {
                try {
                    Content.Source source;
                    ServletContextHandler contextHandler = servletContextRequest.getServletContext().getServletContextHandler();
                    ByteBufferPool byteBufferPool = servletContextRequest.getComponents().getByteBufferPool();
                    ConnectionMetaData connectionMetaData = servletContextRequest.getConnectionMetaData();
                    Connection connection = connectionMetaData.getConnection();
                    if (servletRequest instanceof ServletApiRequest) {
                        ServletApiRequest servletApiRequest = (ServletApiRequest)servletRequest;
                        source = servletApiRequest.getRequest();
                    } else {
                        int n;
                        if (connection instanceof AbstractConnection) {
                            AbstractConnection c = (AbstractConnection)connection;
                            n = c.getInputBufferSize();
                        } else {
                            n = 2048;
                        }
                        int bufferSize = n;
                        InputStreamContentSource iscs = new InputStreamContentSource((InputStream)servletRequest.getInputStream(), byteBufferPool);
                        iscs.setBufferSize(bufferSize);
                        source = iscs;
                    }
                    parser.setMaxParts(contextHandler.getMaxFormKeys());
                    parser.setFilesDirectory(filesDirectory.toPath());
                    parser.setMaxMemoryFileSize(config.getFileSizeThreshold());
                    parser.setMaxFileSize(config.getMaxFileSize());
                    parser.setMaxLength(config.getMaxRequestSize());
                    parser.setPartHeadersMaxLength(connectionMetaData.getHttpConfiguration().getRequestHeaderSize());
                    return parser.parse(source);
                }
                catch (Throwable failure) {
                    return CompletableFuture.failedFuture(failure);
                }
            });
            futureServletParts = futureFormData.thenApply(formDataParts -> new Parts(filesDirectory.toPath(), (MultiPartFormData.Parts)formDataParts));
            servletRequest.setAttribute(ServletMultiPartFormData.class.getName(), (Object)futureServletParts);
        }
        return futureServletParts;
    }

    public static class Parts {
        private final List<Part> parts = new ArrayList<Part>();

        public Parts(Path directory, MultiPartFormData.Parts parts) {
            parts.forEach(part -> this.parts.add(new ServletPart(directory, (MultiPart.Part)part)));
        }

        public Part getPart(String name) {
            return this.parts.stream().filter(part -> part.getName().equals(name)).findFirst().orElse(null);
        }

        public Collection<Part> getParts() {
            return List.copyOf(this.parts);
        }
    }

    private static class ServletPart
    implements Part {
        private final Path _directory;
        private final MultiPart.Part _part;

        private ServletPart(Path directory, MultiPart.Part part) {
            this._directory = directory;
            this._part = part;
        }

        public InputStream getInputStream() throws IOException {
            return Content.Source.asInputStream(this._part.newContentSource());
        }

        public String getContentType() {
            return this._part.getHeaders().get(HttpHeader.CONTENT_TYPE);
        }

        public String getName() {
            return this._part.getName();
        }

        public String getSubmittedFileName() {
            return this._part.getFileName();
        }

        public long getSize() {
            return this._part.getLength();
        }

        public void write(String fileName) throws IOException {
            Path filePath = Path.of(fileName, new String[0]);
            if (!filePath.isAbsolute() && Files.isDirectory(this._directory, new LinkOption[0])) {
                filePath = this._directory.resolve(filePath).normalize();
            }
            this._part.writeTo(filePath);
        }

        public void delete() throws IOException {
            this._part.delete();
        }

        public String getHeader(String name) {
            return this._part.getHeaders().get(name);
        }

        public Collection<String> getHeaders(String name) {
            return this._part.getHeaders().getValuesList(name);
        }

        public Collection<String> getHeaderNames() {
            return this._part.getHeaders().getFieldNamesCollection();
        }

        public String toString() {
            return "%s@%x[part=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this._part);
        }
    }
}

