/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.ByteBufferInputStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;

public class ServletCoreResponse
implements Response {
    private final HttpServletResponse _httpServletResponse;
    private final Request _coreRequest;
    private final HttpFields.Mutable _httpFields;
    private final boolean _included;
    private final ServletContextResponse _servletContextResponse;
    private final boolean _wrapped;

    public Response wrap(Request coreRequest, HttpServletResponse httpServletResponse, boolean included) {
        return new ServletCoreResponse(coreRequest, httpServletResponse, included);
    }

    ServletCoreResponse(Request coreRequest, HttpServletResponse httpServletResponse, boolean included) {
        this._coreRequest = coreRequest;
        this._httpServletResponse = httpServletResponse;
        this._servletContextResponse = ServletContextResponse.getServletContextResponse((ServletResponse)httpServletResponse);
        this._wrapped = !(httpServletResponse instanceof ServletApiResponse);
        HttpFields.Mutable fields = new HttpServletResponseHttpFields(httpServletResponse);
        if (included) {
            fields = new HttpFields.Mutable.Wrapper(fields){

                @Override
                public HttpField onAddField(HttpField field) {
                    String name;
                    String string = name = field == null ? null : field.getName();
                    if (!StringUtil.isBlank(name) && name.startsWith("org.eclipse.jetty.server.include.")) {
                        return new HttpField(name.substring("org.eclipse.jetty.server.include.".length()), field.getValue());
                    }
                    return null;
                }

                @Override
                public boolean onRemoveField(HttpField field) {
                    return false;
                }

                @Override
                public HttpField onReplaceField(HttpField oldField, HttpField newField) {
                    return oldField;
                }
            };
        }
        this._httpFields = fields;
        this._included = included;
    }

    @Override
    public HttpFields.Mutable getHeaders() {
        return this._httpFields;
    }

    public HttpServletResponse getServletResponse() {
        return this._httpServletResponse;
    }

    @Override
    public boolean hasLastWrite() {
        return this._servletContextResponse.hasLastWrite();
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this._servletContextResponse.isCompletedSuccessfully();
    }

    @Override
    public boolean isCommitted() {
        return this._httpServletResponse.isCommitted();
    }

    private boolean isWriting() {
        return this._servletContextResponse.isWriting();
    }

    @Override
    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        block19: {
            if (this._included) {
                last = false;
            }
            try {
                if (!this._wrapped && !this._servletContextResponse.isWritingOrStreaming()) {
                    this._servletContextResponse.write(last, byteBuffer, callback);
                    break block19;
                }
                if (BufferUtil.hasContent(byteBuffer)) {
                    if (this.isWriting()) {
                        String characterEncoding = this._httpServletResponse.getCharacterEncoding();
                        try (ByteBufferInputStream bbis = new ByteBufferInputStream(byteBuffer);
                             InputStreamReader reader = new InputStreamReader((InputStream)bbis, characterEncoding);){
                            IO.copy(reader, this._httpServletResponse.getWriter());
                        }
                        if (last) {
                            this._httpServletResponse.getWriter().close();
                        }
                    } else {
                        BufferUtil.writeTo(byteBuffer, (OutputStream)this._httpServletResponse.getOutputStream());
                        if (last) {
                            this._httpServletResponse.getOutputStream().close();
                        }
                    }
                }
                callback.succeeded();
            }
            catch (Throwable t) {
                callback.failed(t);
            }
        }
    }

    @Override
    public Request getRequest() {
        return this._coreRequest;
    }

    @Override
    public int getStatus() {
        return this._httpServletResponse.getStatus();
    }

    @Override
    public void setStatus(int code) {
        if (this._included) {
            return;
        }
        this._httpServletResponse.setStatus(code);
    }

    @Override
    public Supplier<HttpFields> getTrailersSupplier() {
        return null;
    }

    @Override
    public void setTrailersSupplier(Supplier<HttpFields> trailers) {
    }

    @Override
    public void reset() {
        this._httpServletResponse.reset();
    }

    @Override
    public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
        return this._servletContextResponse.writeInterim(status, headers);
    }

    public String toString() {
        return "%s@%x{%s,%s}".formatted(this.getClass().getSimpleName(), this.hashCode(), this._coreRequest, this._httpServletResponse);
    }

    private static class HttpServletResponseHttpFields
    implements HttpFields.Mutable {
        private final HttpServletResponse _response;

        private HttpServletResponseHttpFields(HttpServletResponse response) {
            this._response = response;
        }

        @Override
        public ListIterator<HttpField> listIterator(int index) {
            final ListIterator list = this._response.getHeaderNames().stream().map(n -> new HttpField((String)n, this._response.getHeader(n))).collect(Collectors.toList()).listIterator(index);
            return new ListIterator<HttpField>(){
                HttpField _last;

                @Override
                public boolean hasNext() {
                    return list.hasNext();
                }

                @Override
                public HttpField next() {
                    this._last = (HttpField)list.next();
                    return this._last;
                }

                @Override
                public boolean hasPrevious() {
                    return list.hasPrevious();
                }

                @Override
                public HttpField previous() {
                    this._last = (HttpField)list.previous();
                    return this._last;
                }

                @Override
                public int nextIndex() {
                    return list.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return list.previousIndex();
                }

                @Override
                public void remove() {
                    if (this._last != null) {
                        list.remove();
                        _response.setHeader(this._last.getName(), null);
                    }
                }

                @Override
                public void set(HttpField httpField) {
                    list.set(httpField);
                    _response.setHeader(httpField.getName(), httpField.getValue());
                }

                @Override
                public void add(HttpField httpField) {
                    list.add(httpField);
                    _response.addHeader(httpField.getName(), httpField.getValue());
                }
            };
        }

        @Override
        public HttpFields.Mutable add(String name, String value) {
            this._response.addHeader(name, value);
            return this;
        }

        @Override
        public HttpFields.Mutable add(HttpHeader header, HttpHeaderValue value) {
            this._response.addHeader(header.asString(), value.asString());
            return this;
        }

        @Override
        public HttpFields.Mutable add(HttpHeader header, String value) {
            this._response.addHeader(header.asString(), value);
            return this;
        }

        @Override
        public HttpFields.Mutable add(HttpField field) {
            this._response.addHeader(field.getName(), field.getValue());
            return this;
        }

        @Override
        public HttpFields.Mutable put(HttpField field) {
            this._response.setHeader(field.getName(), field.getValue());
            return this;
        }

        @Override
        public HttpFields.Mutable put(String name, String value) {
            this._response.setHeader(name, value);
            return this;
        }

        @Override
        public HttpFields.Mutable put(HttpHeader header, HttpHeaderValue value) {
            this._response.setHeader(header.asString(), value.asString());
            return this;
        }

        @Override
        public HttpFields.Mutable put(HttpHeader header, String value) {
            this._response.setHeader(header.asString(), value);
            return this;
        }

        @Override
        public HttpFields.Mutable put(String name, List<String> list) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(list);
            boolean first = true;
            for (String s : list) {
                if (first) {
                    this._response.setHeader(name, s);
                } else {
                    this._response.addHeader(name, s);
                }
                first = false;
            }
            return this;
        }

        @Override
        public HttpFields.Mutable remove(HttpHeader header) {
            this._response.setHeader(header.asString(), null);
            return this;
        }

        @Override
        public HttpFields.Mutable remove(EnumSet<HttpHeader> fields) {
            for (HttpHeader header : fields) {
                this.remove(header);
            }
            return this;
        }

        @Override
        public HttpFields.Mutable remove(String name) {
            this._response.setHeader(name, null);
            return this;
        }
    }
}

