/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class InputStreamContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final InputStream inputStream;
    private final ByteBufferPool bufferPool;
    private int bufferSize = 4096;
    private boolean useDirectByteBuffers;
    private Runnable demandCallback;
    private Content.Chunk errorChunk;
    private boolean closed;

    public InputStreamContentSource(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamContentSource(InputStream inputStream, ByteBufferPool bufferPool) {
        this.inputStream = Objects.requireNonNull(inputStream);
        this.bufferPool = bufferPool != null ? bufferPool : new ByteBufferPool.NonPooling();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public Content.Chunk read() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk != null) {
                Content.Chunk chunk = this.errorChunk;
                return chunk;
            }
            if (this.closed) {
                Content.Chunk chunk = Content.Chunk.EOF;
                return chunk;
            }
        }
        RetainableByteBuffer streamBuffer = this.bufferPool.acquire(this.getBufferSize(), this.useDirectByteBuffers);
        try {
            ByteBuffer buffer = streamBuffer.getByteBuffer();
            int read = this.fillBufferFromInputStream(this.inputStream, buffer.array());
            if (read < 0) {
                streamBuffer.release();
                this.close();
                return Content.Chunk.EOF;
            }
            buffer.limit(read);
            return Content.Chunk.asChunk(buffer, false, streamBuffer);
        }
        catch (Throwable x) {
            streamBuffer.release();
            return this.failure(x);
        }
    }

    protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer) throws IOException {
        return inputStream.read(buffer, 0, buffer.length);
    }

    private void close() {
        try (AutoLock ignored = this.lock.lock();){
            this.closed = true;
        }
        IO.close(this.inputStream);
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.failure(failure);
    }

    private Content.Chunk failure(Throwable failure) {
        Content.Chunk error;
        try (AutoLock ignored = this.lock.lock();){
            error = this.errorChunk;
            if (error == null) {
                error = this.errorChunk = Content.Chunk.from(failure);
            }
        }
        IO.close(this.inputStream);
        return error;
    }
}

