/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.generator.PriorityGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) throws HpackException {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(accumulator, headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public int generateHeaders(ByteBufferPool.Accumulator accumulator, int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData, this.getMaxFrameSize());
        ByteBuffer hpackByteBuffer = hpack.getByteBuffer();
        int hpackLength = hpackByteBuffer.position();
        BufferUtil.flipToFlush(hpackByteBuffer, 0);
        if (this.maxHeaderBlockFragment > 0 && hpackLength > this.maxHeaderBlockFragment) {
            if (endStream) {
                flags |= 1;
            }
            int length = this.maxHeaderBlockFragment;
            if (priority != null) {
                length += 5;
            }
            RetainableByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
            ByteBuffer headerByteBuffer = header.getByteBuffer();
            this.generatePriority(headerByteBuffer, priority);
            BufferUtil.flipToFlush(headerByteBuffer, 0);
            accumulator.append(header);
            hpackByteBuffer.limit(this.maxHeaderBlockFragment);
            accumulator.append(RetainableByteBuffer.wrap(hpackByteBuffer.slice()));
            int totalLength = 9 + length;
            int position = this.maxHeaderBlockFragment;
            int limit = position + this.maxHeaderBlockFragment;
            while (limit < hpackLength) {
                hpackByteBuffer.position(position).limit(limit);
                header = this.generateHeader(FrameType.CONTINUATION, this.maxHeaderBlockFragment, 0, streamId);
                headerByteBuffer = header.getByteBuffer();
                BufferUtil.flipToFlush(headerByteBuffer, 0);
                accumulator.append(header);
                accumulator.append(RetainableByteBuffer.wrap(hpackByteBuffer.slice()));
                position += this.maxHeaderBlockFragment;
                limit += this.maxHeaderBlockFragment;
                totalLength += 9 + this.maxHeaderBlockFragment;
            }
            hpackByteBuffer.position(position).limit(hpackLength);
            header = this.generateHeader(FrameType.CONTINUATION, hpack.remaining(), 4, streamId);
            headerByteBuffer = header.getByteBuffer();
            BufferUtil.flipToFlush(headerByteBuffer, 0);
            accumulator.append(header);
            accumulator.append(hpack);
            return totalLength += 9 + hpack.remaining();
        }
        flags |= 4;
        if (endStream) {
            flags |= 1;
        }
        int length = hpackLength;
        if (priority != null) {
            length += 5;
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
        ByteBuffer headerByteBuffer = header.getByteBuffer();
        this.generatePriority(headerByteBuffer, priority);
        BufferUtil.flipToFlush(headerByteBuffer, 0);
        accumulator.append(header);
        accumulator.append(hpack);
        return 9 + length;
    }

    private void generatePriority(ByteBuffer header, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(header, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

